# Database and Form Update - Feeding Centers and Payment

This update adds support for tracking three new client settings in the billing system:

1. Enjaz Feeding Center
2. Umrah Feeding Center
3. Enjaz Payment

## Files Changed

1. `pages/edit_client.php` - Added three new checkbox fields in the client form
2. `form_process.php` - Updated form processing to handle the new fields for both adding and editing clients
3. `update_database.php` - Created script to update the database schema
4. `db.php` - Updated API response to include the new fields

## How to Apply the Update

1. Upload all changed files to the server
2. Run the `update_database.php` script by visiting it in a browser (e.g., https://yourdomain.com/update_database.php)
2. Upload the updated `db.php` file to your API server location: `/home5/authumra/public_html/v6/db.php`
3. After the database is updated, you can use the client edit form with the new fields

## Technical Details

The changes include:

- Adding three new TINYINT columns to the `tbl_clients` table:
  - `enjaz_feeding_center` (default 0)
  - `umrah_feeding_center` (default 0)
  - `enjaz_payment` (default 0)
- Adding form fields in the client edit page
- Updating form processing to handle the new fields
- Updating the API response to include the new fields in the `result_info` string:
  ```
  $result_info = "$cloud_database|$cloud_username|$cloud_password|$ftp_password|$ftp_username|$mofa_username|$mofa_password|$free_license|$b2c_license|$feeding_center|$enjaz_feeding_center|$umrah_feeding_center|$enjaz_payment|END";
  ```

## Verifying the Update

After applying the update, you should:

1. Visit the client edit page for an existing client
2. Verify the new checkboxes appear
3. Test saving a client with the checkboxes checked and unchecked
4. Verify the values are saved correctly in the database
5. Test the API response to ensure the new fields are properly included 