<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once '../includes/config.php';

header('Content-Type: application/json');

// Start session
session_start();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

try {
    if (empty($data['username']) || empty($data['password'])) {
        throw new Exception('Username and password are required');
    }
    
    $username = $data['username'];
    $password = $data['password'];
    
    // Query to check admin user
    $stmt = $db1->prepare("SELECT id, User_Name, Type, Country 
                         FROM tbl_users 
                         WHERE User_Name = ? 
                         AND Password = ? 
                         AND Type IN ('admin', 'user')
                         LIMIT 1");
                         
    $stmt->execute([$username, md5($password)]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        // Set session variables
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['admin_username'] = $user['User_Name'];
        $_SESSION['admin_type'] = $user['Type'];
        $_SESSION['admin_id'] = $user['id'];
        $_SESSION['admin_country'] = $user['Country'];
        
        echo json_encode([
            'success' => true,
            'message' => 'Login successful',
            'user' => [
                'id' => $user['id'],
                'username' => $user['User_Name'],
                'type' => $user['Type'],
                'country' => $user['Country']
            ],
            'session_id' => session_id()
        ]);
    } else {
        http_response_code(401);
        echo json_encode([
            'success' => false,
            'error' => 'Invalid username or password'
        ]);
    }
    
} catch (Exception $e) {
    error_log("Login API - Error: " . $e->getMessage());
    
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'debug_info' => DEVELOPMENT_MODE ? [
            'file' => $e->getFile(),
            'line' => $e->getLine()
        ] : null
    ]);
}
?>
