-- --------------------------------------------------------
-- Host:                         server6.virgo-host.com
-- Server version:               10.11.11-MariaDB - MariaDB Server
-- Server OS:                    Linux
-- HeidiSQL Version:             12.6.0.6765
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

-- Dumping structure for table authumra_offline2017.activate
CREATE TABLE IF NOT EXISTS `activate` (
  `activate_id` int(11) NOT NULL AUTO_INCREMENT,
  `licensecode` varchar(50) NOT NULL,
  `language` varchar(2) NOT NULL,
  `nationality` varchar(3) NOT NULL,
  `mofanumber` varchar(15) NOT NULL,
  `passportnumber` varchar(9) NOT NULL,
  `enumber` varchar(15) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `firstname` varchar(25) DEFAULT NULL,
  `secondname` varchar(25) DEFAULT NULL,
  `thirdname` varchar(25) DEFAULT NULL,
  `lastname` varchar(25) DEFAULT NULL,
  `visatype` int(10) DEFAULT 0,
  `activatestatus_id` int(10) DEFAULT 0,
  `link` text NOT NULL DEFAULT '',
  `visanumber` varchar(50) DEFAULT NULL,
  `visadate` varchar(50) DEFAULT NULL,
  `visaexpirydate` varchar(50) DEFAULT NULL,
  `visaduration` varchar(50) DEFAULT NULL,
  `visaplaceofissue` varchar(50) DEFAULT NULL,
  `visafullname` varchar(50) DEFAULT NULL,
  `visanationality` varchar(50) DEFAULT NULL,
  `visatypetext` varchar(50) DEFAULT NULL,
  `visaumrahagent` varchar(50) DEFAULT NULL,
  `visaexternalagent` varchar(50) DEFAULT NULL,
  `visabordernumber` varchar(50) DEFAULT NULL,
  `visaenumber` varchar(50) DEFAULT NULL,
  `visamahram` varchar(50) DEFAULT NULL,
  `visaimage` text DEFAULT NULL,
  PRIMARY KEY (`activate_id`),
  KEY `mofa` (`mofanumber`),
  KEY `passport` (`nationality`,`mofanumber`,`passportnumber`),
  KEY `FK_activate_license` (`licensecode`),
  KEY `activate` (`status`,`date`,`activate_id`),
  CONSTRAINT `FK_activate_license` FOREIGN KEY (`licensecode`) REFERENCES `license` (`license_code`)
) ENGINE=InnoDB AUTO_INCREMENT=284 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.captcha_requests
CREATE TABLE IF NOT EXISTS `captcha_requests` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `incoming_request` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`incoming_request`)),
  `body` longtext NOT NULL,
  `task_id` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `response` text DEFAULT NULL,
  `result` varchar(50) DEFAULT NULL,
  `license` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `Index 2` (`task_id`),
  KEY `body` (`body`(100))
) ENGINE=InnoDB AUTO_INCREMENT=1649621 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.captcha_requests_archive
CREATE TABLE IF NOT EXISTS `captcha_requests_archive` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `incoming_request` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`incoming_request`)),
  `body` longtext NOT NULL,
  `task_id` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `response` text DEFAULT NULL,
  `result` varchar(50) DEFAULT NULL,
  `license` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `Index 2` (`task_id`),
  KEY `body` (`body`(100))
) ENGINE=InnoDB AUTO_INCREMENT=1157973 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.captcha_requests_archive_1446
CREATE TABLE IF NOT EXISTS `captcha_requests_archive_1446` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `incoming_request` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`incoming_request`)),
  `body` longtext NOT NULL,
  `task_id` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `response` text DEFAULT NULL,
  `license` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `Index 2` (`task_id`),
  KEY `body` (`body`(100))
) ENGINE=InnoDB AUTO_INCREMENT=777312 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.captcha_requests_old
CREATE TABLE IF NOT EXISTS `captcha_requests_old` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `incoming_request` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `task_id` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `response` text DEFAULT NULL,
  `license` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `Index 2` (`task_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=531466 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.

-- Dumping structure for view authumra_offline2017.captcha_view
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `captcha_view` (
	`COUNT(*)` BIGINT(21) NOT NULL,
	`license` VARCHAR(255) NOT NULL COLLATE 'utf8mb3_general_ci',
	`CompanyName` VARCHAR(100) NULL COLLATE 'utf8mb3_general_ci'
) ENGINE=MyISAM;

-- Dumping structure for view authumra_offline2017.clients_version
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `clients_version` (
	`Id` INT(10) NOT NULL,
	`companyname` VARCHAR(100) NOT NULL COLLATE 'utf8mb3_general_ci',
	`version` VARCHAR(10) NULL COLLATE 'utf8mb3_general_ci'
) ENGINE=MyISAM;

-- Dumping structure for table authumra_offline2017.crm_ea_machines
CREATE TABLE IF NOT EXISTS `crm_ea_machines` (
  `crm_ea_machine_id` int(10) NOT NULL AUTO_INCREMENT,
  `safa_ea_id` int(10) DEFAULT NULL,
  `last_access` datetime DEFAULT NULL,
  `code` int(10) DEFAULT NULL,
  `ip` varchar(16) DEFAULT NULL,
  `hash` varchar(32) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `safa_client_id` int(11) DEFAULT NULL,
  `version` varchar(25) DEFAULT NULL,
  `virgo_machine` tinyint(3) DEFAULT 0,
  PRIMARY KEY (`crm_ea_machine_id`),
  UNIQUE KEY `hash` (`hash`) USING BTREE,
  KEY `FK____safa_eas` (`safa_ea_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=449 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.crm_ea_machines_2017
CREATE TABLE IF NOT EXISTS `crm_ea_machines_2017` (
  `crm_ea_machine_id` int(10) NOT NULL AUTO_INCREMENT,
  `safa_ea_id` int(10) DEFAULT NULL,
  `last_access` datetime DEFAULT NULL,
  `code` int(10) DEFAULT NULL,
  `ip` varchar(16) DEFAULT NULL,
  `hash` varchar(32) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `safa_client_id` int(10) DEFAULT NULL,
  PRIMARY KEY (`crm_ea_machine_id`),
  UNIQUE KEY `hash` (`hash`) USING BTREE,
  KEY `FK____safa_eas` (`safa_ea_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6932 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.crm_ea_machines_2018
CREATE TABLE IF NOT EXISTS `crm_ea_machines_2018` (
  `crm_ea_machine_id` int(10) NOT NULL AUTO_INCREMENT,
  `safa_ea_id` int(10) DEFAULT NULL,
  `last_access` datetime DEFAULT NULL,
  `code` int(10) DEFAULT NULL,
  `ip` varchar(16) DEFAULT NULL,
  `hash` varchar(32) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `safa_client_id` int(10) DEFAULT NULL,
  PRIMARY KEY (`crm_ea_machine_id`),
  UNIQUE KEY `hash` (`hash`) USING BTREE,
  KEY `FK____safa_eas` (`safa_ea_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7286 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.crm_ea_machines_2019
CREATE TABLE IF NOT EXISTS `crm_ea_machines_2019` (
  `crm_ea_machine_id` int(10) NOT NULL AUTO_INCREMENT,
  `safa_ea_id` int(10) DEFAULT NULL,
  `last_access` datetime DEFAULT NULL,
  `code` int(10) DEFAULT NULL,
  `ip` varchar(16) DEFAULT NULL,
  `hash` varchar(32) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `safa_client_id` int(11) DEFAULT NULL,
  `version` varchar(25) DEFAULT NULL,
  `virgo_machine` tinyint(3) DEFAULT 0,
  PRIMARY KEY (`crm_ea_machine_id`),
  UNIQUE KEY `hash` (`hash`) USING BTREE,
  KEY `FK____safa_eas` (`safa_ea_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8060 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.crm_ea_machines_2021
CREATE TABLE IF NOT EXISTS `crm_ea_machines_2021` (
  `crm_ea_machine_id` int(10) NOT NULL AUTO_INCREMENT,
  `safa_ea_id` int(10) DEFAULT NULL,
  `last_access` datetime DEFAULT NULL,
  `code` int(10) DEFAULT NULL,
  `ip` varchar(16) DEFAULT NULL,
  `hash` varchar(32) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `safa_client_id` int(11) DEFAULT NULL,
  `version` varchar(25) DEFAULT NULL,
  `virgo_machine` tinyint(3) DEFAULT 0,
  PRIMARY KEY (`crm_ea_machine_id`) USING BTREE,
  UNIQUE KEY `hash` (`hash`) USING BTREE,
  KEY `FK____safa_eas` (`safa_ea_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9483 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.crm_ea_machines_2023
CREATE TABLE IF NOT EXISTS `crm_ea_machines_2023` (
  `crm_ea_machine_id` int(10) NOT NULL AUTO_INCREMENT,
  `safa_ea_id` int(10) DEFAULT NULL,
  `last_access` datetime DEFAULT NULL,
  `code` int(10) DEFAULT NULL,
  `ip` varchar(16) DEFAULT NULL,
  `hash` varchar(32) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `safa_client_id` int(11) DEFAULT NULL,
  `version` varchar(25) DEFAULT NULL,
  `virgo_machine` tinyint(3) DEFAULT 0,
  PRIMARY KEY (`crm_ea_machine_id`) USING BTREE,
  UNIQUE KEY `hash` (`hash`) USING BTREE,
  KEY `FK____safa_eas` (`safa_ea_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10629 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.crm_ea_machines_2024
CREATE TABLE IF NOT EXISTS `crm_ea_machines_2024` (
  `crm_ea_machine_id` int(10) NOT NULL AUTO_INCREMENT,
  `safa_ea_id` int(10) DEFAULT NULL,
  `last_access` datetime DEFAULT NULL,
  `code` int(10) DEFAULT NULL,
  `ip` varchar(16) DEFAULT NULL,
  `hash` varchar(32) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `safa_client_id` int(11) DEFAULT NULL,
  `version` varchar(25) DEFAULT NULL,
  `virgo_machine` tinyint(3) DEFAULT 0,
  PRIMARY KEY (`crm_ea_machine_id`) USING BTREE,
  UNIQUE KEY `hash` (`hash`) USING BTREE,
  KEY `FK____safa_eas` (`safa_ea_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10685 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.

-- Dumping structure for view authumra_offline2017.egypt_visas
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `egypt_visas` (
	`Id` INT(10) NULL,
	`companyname` VARCHAR(100) NULL COLLATE 'utf8mb3_general_ci',
	`counter` BIGINT(21) NOT NULL
) ENGINE=MyISAM;

-- Dumping structure for view authumra_offline2017.hajj_1439
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `hajj_1439` (
	`count(*)` BIGINT(21) NOT NULL,
	`client_id` INT(11) NULL,
	`CompanyName` VARCHAR(100) NULL COLLATE 'utf8mb3_general_ci',
	`Country` INT(10) NULL
) ENGINE=MyISAM;

-- Dumping structure for table authumra_offline2017.jordan_cc
CREATE TABLE IF NOT EXISTS `jordan_cc` (
  `cc_id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) NOT NULL DEFAULT 0,
  `status` int(11) NOT NULL DEFAULT 0,
  `response` text DEFAULT NULL,
  `date_request` datetime NOT NULL,
  `date_response` datetime DEFAULT NULL,
  PRIMARY KEY (`cc_id`),
  KEY `Index 2` (`date_response`)
) ENGINE=InnoDB AUTO_INCREMENT=5906 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.jordan_cc_copy
CREATE TABLE IF NOT EXISTS `jordan_cc_copy` (
  `cc_id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) NOT NULL DEFAULT 0,
  `status` int(11) NOT NULL DEFAULT 0,
  `response` text DEFAULT NULL,
  `date_request` datetime NOT NULL,
  `date_response` datetime DEFAULT NULL,
  PRIMARY KEY (`cc_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=259 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.license
CREATE TABLE IF NOT EXISTS `license` (
  `license_id` int(11) NOT NULL AUTO_INCREMENT,
  `license_code` varchar(50) NOT NULL,
  `client_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`license_id`),
  KEY `code` (`license_code`),
  KEY `FK_license_tbl_clients` (`client_id`) USING BTREE,
  CONSTRAINT `FK_license_tbl_clients` FOREIGN KEY (`client_id`) REFERENCES `tbl_clients` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=1002 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.license_copy
CREATE TABLE IF NOT EXISTS `license_copy` (
  `license_id` int(11) NOT NULL AUTO_INCREMENT,
  `license_code` varchar(50) NOT NULL,
  `client_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`license_id`) USING BTREE,
  UNIQUE KEY `FK_license_tbl_clients` (`client_id`) USING BTREE,
  CONSTRAINT `license_copy_ibfk_1` FOREIGN KEY (`client_id`) REFERENCES `tbl_clients` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=1002 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.location_requests
CREATE TABLE IF NOT EXISTS `location_requests` (
  `rq_id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(15) NOT NULL DEFAULT '0',
  `country` varchar(15) NOT NULL DEFAULT '0',
  `code` varchar(15) NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`rq_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin;

-- Data exporting was unselected.

-- Dumping structure for procedure authumra_offline2017.merge_clients
DELIMITER //
CREATE PROCEDURE `merge_clients`(
	IN `from_client` INT,
	IN `to_client` INT
)
BEGIN
  UPDATE visas_1439 SET client_id=`to_client` WHERE client_id=`from_client`;
  UPDATE visas_1440 SET client_id=`to_client` WHERE client_id=`from_client`;
  UPDATE visas_1441 SET client_id=`to_client` WHERE client_id=`from_client`;
  UPDATE visas_1442 SET client_id=`to_client` WHERE client_id=`from_client`;
  UPDATE visas_1443 SET client_id=`to_client` WHERE client_id=`from_client`;
  UPDATE visas_1444 SET client_id=`to_client` WHERE client_id=`from_client`;
  UPDATE passports_1440 SET client_id=`to_client` WHERE client_id=`from_client`; 
  UPDATE passports_1441 SET client_id=`to_client` WHERE client_id=`from_client`;  
  UPDATE passports_1442 SET client_id=`to_client` WHERE client_id=`from_client`;
  UPDATE passports_1443 SET client_id=`to_client` WHERE client_id=`from_client`;
  UPDATE passports_1444 SET client_id=`to_client` WHERE client_id=`from_client`;
  UPDATE authumra_visas.visa_number SET user_id =  `to_client` WHERE user_id=`from_client`;
  UPDATE crm_ea_machines SET safa_client_id=`to_client` WHERE safa_client_id=`from_client`;
  UPDATE license SET client_id=`to_client` WHERE client_id=`from_client`;
  DELETE from tbl_clients WHERE id = `from_client`;
END//
DELIMITER ;

-- Dumping structure for table authumra_offline2017.muqeem_log
CREATE TABLE IF NOT EXISTS `muqeem_log` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `value` text DEFAULT NULL,
  `PPNo` varchar(15) DEFAULT NULL,
  `NatID` int(11) DEFAULT NULL,
  `arrivalDate` date DEFAULT NULL,
  `license` varchar(50) DEFAULT NULL,
  `IP` varchar(60) DEFAULT NULL,
  `Reference` varchar(50) DEFAULT NULL,
  `last_update` datetime DEFAULT NULL,
  `start_time` datetime DEFAULT NULL,
  `end_time` datetime DEFAULT NULL,
  `Response` text DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  UNIQUE KEY `Index 2` (`NatID`,`arrivalDate`,`PPNo`)
) ENGINE=InnoDB AUTO_INCREMENT=42463 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.muqeem_log_1443
CREATE TABLE IF NOT EXISTS `muqeem_log_1443` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `value` text DEFAULT NULL,
  `PPNo` varchar(15) DEFAULT NULL,
  `NatID` int(11) DEFAULT NULL,
  `arrivalDate` date DEFAULT NULL,
  `license` varchar(50) DEFAULT NULL,
  `IP` varchar(60) DEFAULT NULL,
  `Reference` varchar(50) DEFAULT NULL,
  `last_update` datetime DEFAULT NULL,
  `start_time` datetime DEFAULT NULL,
  `end_time` datetime DEFAULT NULL,
  `Response` text DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  UNIQUE KEY `Index 2` (`NatID`,`arrivalDate`,`PPNo`)
) ENGINE=InnoDB AUTO_INCREMENT=32522 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.nation
CREATE TABLE IF NOT EXISTS `nation` (
  `Seq` int(10) NOT NULL AUTO_INCREMENT,
  `name_la` varchar(50) DEFAULT NULL,
  `name_ar` varchar(50) DEFAULT NULL,
  `country_id` int(10) unsigned DEFAULT NULL,
  `code` varchar(3) DEFAULT NULL,
  `english` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`Seq`),
  UNIQUE KEY `country_id` (`country_id`),
  KEY `code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=249 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.numbers
CREATE TABLE IF NOT EXISTS `numbers` (
  `number_id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(50) NOT NULL,
  `client_id` int(11) DEFAULT NULL,
  `batch` int(11) DEFAULT NULL,
  `sms` int(11) DEFAULT NULL,
  PRIMARY KEY (`number_id`),
  UNIQUE KEY `Index 2` (`number`),
  KEY `FK_numbers_tbl_clients` (`client_id`),
  CONSTRAINT `FK_numbers_tbl_clients` FOREIGN KEY (`client_id`) REFERENCES `tbl_clients` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=3044 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1438
CREATE TABLE IF NOT EXISTS `passports_1438` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `Index 2` (`pilgrimId`,`ppno`,`nationality`,`code`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=48039 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1439
CREATE TABLE IF NOT EXISTS `passports_1439` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`),
  UNIQUE KEY `Index 2` (`pilgrimId`,`ppno`,`nationality`,`code`)
) ENGINE=InnoDB AUTO_INCREMENT=48039 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1440
CREATE TABLE IF NOT EXISTS `passports_1440` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`),
  UNIQUE KEY `Index 2` (`pilgrimId`,`ppno`,`nationality`,`code`),
  KEY `FK_passports_1440_tbl_clients` (`client_id`),
  KEY `Visa` (`type`,`client_id`),
  CONSTRAINT `FK_passports_1440_tbl_clients` FOREIGN KEY (`client_id`) REFERENCES `tbl_clients` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=4524812 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1441
CREATE TABLE IF NOT EXISTS `passports_1441` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`),
  UNIQUE KEY `Index 2` (`pilgrimId`,`ppno`,`nationality`,`code`),
  KEY `Visa` (`client_id`,`type`) USING BTREE,
  CONSTRAINT `FK_passports_1441_tbl_clients` FOREIGN KEY (`client_id`) REFERENCES `tbl_clients` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=4694051 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1442
CREATE TABLE IF NOT EXISTS `passports_1442` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `Index 2` (`pilgrimId`,`ppno`,`nationality`,`code`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`) USING BTREE,
  CONSTRAINT `FK_passports_1442_tbl_clients` FOREIGN KEY (`client_id`) REFERENCES `tbl_clients` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=2320 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1443
CREATE TABLE IF NOT EXISTS `passports_1443` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `Index 2` (`pilgrimId`,`ppno`,`nationality`,`code`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`) USING BTREE,
  CONSTRAINT `passports_1443_ibfk_1` FOREIGN KEY (`client_id`) REFERENCES `tbl_clients` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=189953 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1444
CREATE TABLE IF NOT EXISTS `passports_1444` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `Index 2` (`code`,`nationality`,`pilgrimId`,`ppno`,`mofa`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE,
  CONSTRAINT `passports_1444_ibfk_1` FOREIGN KEY (`client_id`) REFERENCES `tbl_clients` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=766518 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1445
CREATE TABLE IF NOT EXISTS `passports_1445` (
  `passport_id` int(11) NOT NULL DEFAULT 0,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL DEFAULT '',
  `nationality` int(11) NOT NULL DEFAULT 0,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL DEFAULT 0,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL DEFAULT '',
  `code` varchar(100) NOT NULL DEFAULT '',
  `machine` varchar(100) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  KEY `ppno_index` (`ppno`),
  KEY `client_id` (`client_id`,`type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1445_April_2024
CREATE TABLE IF NOT EXISTS `passports_1445_April_2024` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1401237 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1445_August_2023
CREATE TABLE IF NOT EXISTS `passports_1445_August_2023` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=847001 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1445_December_2023
CREATE TABLE IF NOT EXISTS `passports_1445_December_2023` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1086194 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1445_February_2024
CREATE TABLE IF NOT EXISTS `passports_1445_February_2024` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1316054 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1445_full
CREATE TABLE IF NOT EXISTS `passports_1445_full` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE,
  CONSTRAINT `passports_1445_full_ibfk_1` FOREIGN KEY (`client_id`) REFERENCES `tbl_clients` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=1426343 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1445_January_2024
CREATE TABLE IF NOT EXISTS `passports_1445_January_2024` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1226916 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1445_July_2023
CREATE TABLE IF NOT EXISTS `passports_1445_July_2023` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=789712 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1445_June_2024
CREATE TABLE IF NOT EXISTS `passports_1445_June_2024` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1426342 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1445_March_2024
CREATE TABLE IF NOT EXISTS `passports_1445_March_2024` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1371532 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1445_May_2024
CREATE TABLE IF NOT EXISTS `passports_1445_May_2024` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1425766 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1445_November_2023
CREATE TABLE IF NOT EXISTS `passports_1445_November_2023` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1026822 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1445_October_2023
CREATE TABLE IF NOT EXISTS `passports_1445_October_2023` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=976613 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1445_old
CREATE TABLE IF NOT EXISTS `passports_1445_old` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `Index 2` (`code`,`nationality`,`pilgrimId`,`ppno`,`mofa`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE,
  CONSTRAINT `passports_1445_old_ibfk_1` FOREIGN KEY (`client_id`) REFERENCES `tbl_clients` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=857705 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1445_September_2023
CREATE TABLE IF NOT EXISTS `passports_1445_September_2023` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=914894 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for view authumra_offline2017.passports_1445_view
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `passports_1445_view` (
	`passport_id` INT(11) NOT NULL,
	`client_id` INT(11) NULL,
	`pilgrimId` INT(11) NULL,
	`ppno` VARCHAR(25) NOT NULL COLLATE 'utf8mb3_general_ci',
	`nationality` INT(11) NOT NULL,
	`mofa` INT(11) NULL,
	`type` INT(11) NOT NULL,
	`Firstname` VARCHAR(50) NULL COLLATE 'utf8mb3_general_ci',
	`Secondname` VARCHAR(50) NULL COLLATE 'utf8mb3_general_ci',
	`Thirdname` VARCHAR(50) NULL COLLATE 'utf8mb3_general_ci',
	`Lastname` VARCHAR(50) NULL COLLATE 'utf8mb3_general_ci',
	`AFirstname` VARCHAR(50) NULL COLLATE 'utf8mb3_general_ci',
	`ASecondname` VARCHAR(50) NULL COLLATE 'utf8mb3_general_ci',
	`AThirdname` VARCHAR(50) NULL COLLATE 'utf8mb3_general_ci',
	`ALastname` VARCHAR(50) NULL COLLATE 'utf8mb3_general_ci',
	`link` VARCHAR(500) NOT NULL COLLATE 'utf8mb3_general_ci',
	`code` VARCHAR(100) NOT NULL COLLATE 'utf8mb3_general_ci',
	`machine` VARCHAR(100) NULL COLLATE 'utf8mb3_general_ci',
	`timestamp` TIMESTAMP NOT NULL
) ENGINE=MyISAM;

-- Dumping structure for table authumra_offline2017.passports_1446
CREATE TABLE IF NOT EXISTS `passports_1446` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE,
  CONSTRAINT `passports_1446_ibfk_1` FOREIGN KEY (`client_id`) REFERENCES `tbl_clients` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=1982343 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for view authumra_offline2017.passports_1446_2024
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `passports_1446_2024` (
	`passport_id` INT(11) NOT NULL,
	`client_id` INT(11) NULL,
	`pilgrimId` INT(11) NULL,
	`ppno` VARCHAR(25) NOT NULL COLLATE 'utf8mb3_general_ci',
	`nationality` INT(11) NOT NULL,
	`mofa` INT(11) NULL,
	`type` INT(11) NOT NULL,
	`Firstname` VARCHAR(50) NULL COLLATE 'utf8mb3_general_ci',
	`Secondname` VARCHAR(50) NULL COLLATE 'utf8mb3_general_ci',
	`Thirdname` VARCHAR(50) NULL COLLATE 'utf8mb3_general_ci',
	`Lastname` VARCHAR(50) NULL COLLATE 'utf8mb3_general_ci',
	`AFirstname` VARCHAR(50) NULL COLLATE 'utf8mb3_general_ci',
	`ASecondname` VARCHAR(50) NULL COLLATE 'utf8mb3_general_ci',
	`AThirdname` VARCHAR(50) NULL COLLATE 'utf8mb3_general_ci',
	`ALastname` VARCHAR(50) NULL COLLATE 'utf8mb3_general_ci',
	`link` VARCHAR(500) NOT NULL COLLATE 'utf8mb3_general_ci',
	`code` VARCHAR(100) NOT NULL COLLATE 'utf8mb3_general_ci',
	`machine` VARCHAR(100) NULL COLLATE 'utf8mb3_general_ci',
	`timestamp` TIMESTAMP NOT NULL
) ENGINE=MyISAM;

-- Dumping structure for table authumra_offline2017.passports_1446_April_2025
CREATE TABLE IF NOT EXISTS `passports_1446_April_2025` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1371532 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1446_August_2024
CREATE TABLE IF NOT EXISTS `passports_1446_August_2024` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1532279 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1446_August_2025
CREATE TABLE IF NOT EXISTS `passports_1446_August_2025` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1532279 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1446_December_2024
CREATE TABLE IF NOT EXISTS `passports_1446_December_2024` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1775733 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1446_February_2025
CREATE TABLE IF NOT EXISTS `passports_1446_February_2025` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1974334 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1446_January_2025
CREATE TABLE IF NOT EXISTS `passports_1446_January_2025` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1886491 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1446_July_2024
CREATE TABLE IF NOT EXISTS `passports_1446_July_2024` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1476860 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1446_July_2025
CREATE TABLE IF NOT EXISTS `passports_1446_July_2025` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1476860 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1446_June_2024
CREATE TABLE IF NOT EXISTS `passports_1446_June_2024` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1431079 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1446_June_2025
CREATE TABLE IF NOT EXISTS `passports_1446_June_2025` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1431079 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1446_March_2025
CREATE TABLE IF NOT EXISTS `passports_1446_March_2025` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1982342 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1446_May_2025
CREATE TABLE IF NOT EXISTS `passports_1446_May_2025` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1371532 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1446_November_2024
CREATE TABLE IF NOT EXISTS `passports_1446_November_2024` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1701370 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1446_October_2024
CREATE TABLE IF NOT EXISTS `passports_1446_October_2024` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1641950 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.passports_1446_September_2024
CREATE TABLE IF NOT EXISTS `passports_1446_September_2024` (
  `passport_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `pilgrimId` int(11) DEFAULT NULL,
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) NOT NULL,
  `mofa` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `Firstname` varchar(50) DEFAULT NULL,
  `Secondname` varchar(50) DEFAULT NULL,
  `Thirdname` varchar(50) DEFAULT NULL,
  `Lastname` varchar(50) DEFAULT NULL,
  `AFirstname` varchar(50) DEFAULT NULL,
  `ASecondname` varchar(50) DEFAULT NULL,
  `AThirdname` varchar(50) DEFAULT NULL,
  `ALastname` varchar(50) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `code` varchar(100) NOT NULL,
  `machine` varchar(100) DEFAULT NULL,
  `archive` int(11) DEFAULT 0,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`passport_id`) USING BTREE,
  UNIQUE KEY `duplicate` (`code`,`nationality`,`ppno`,`type`) USING BTREE,
  KEY `FK_passports_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `Visa` (`client_id`,`type`,`ppno`,`nationality`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1588655 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for view authumra_offline2017.passports_counter
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `passports_counter` (
	`client_id` INT(11) NULL,
	`companyname` VARCHAR(100) NULL COLLATE 'utf8mb3_general_ci',
	`count(*)` BIGINT(21) NOT NULL
) ENGINE=MyISAM;

-- Dumping structure for view authumra_offline2017.passports_view
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `passports_view` (
	`client_id` INT(11) NULL,
	`type` INT(11) NOT NULL,
	`Counter` BIGINT(21) NOT NULL
) ENGINE=MyISAM;

-- Dumping structure for view authumra_offline2017.re
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `re` (
	`crm_ea_machine_id` INT(10) NOT NULL,
	`safa_ea_id` INT(10) NULL,
	`last_access` DATETIME NULL,
	`code` INT(10) NULL,
	`ip` VARCHAR(16) NULL COLLATE 'utf8mb3_general_ci',
	`hash` VARCHAR(32) NULL COLLATE 'utf8mb3_general_ci',
	`name` VARCHAR(100) NULL COLLATE 'utf8mb3_general_ci',
	`safa_client_id` INT(11) NULL
) ENGINE=MyISAM;

-- Dumping structure for table authumra_offline2017.report_1440
CREATE TABLE IF NOT EXISTS `report_1440` (
  `client_id` int(11) NOT NULL,
  `passport_count` int(11) DEFAULT NULL,
  `enumber_count` int(11) DEFAULT NULL,
  `enjaz_count` int(11) DEFAULT NULL,
  `hajj_count` int(11) DEFAULT NULL,
  `umrah_count` int(11) DEFAULT NULL,
  UNIQUE KEY `client_id` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for view authumra_offline2017.season_1439
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `season_1439` (
	`client_id` INT(11) NOT NULL,
	`companyname` VARCHAR(100) NULL COLLATE 'utf8mb3_general_ci',
	`visa_count` BIGINT(21) NOT NULL,
	`Time_stamp` DATETIME NULL,
	`Version` VARCHAR(10) NULL COLLATE 'utf8mb3_general_ci'
) ENGINE=MyISAM;

-- Dumping structure for table authumra_offline2017.sms
CREATE TABLE IF NOT EXISTS `sms` (
  `sms_id` int(11) NOT NULL AUTO_INCREMENT,
  `sender` varchar(50) NOT NULL DEFAULT '0',
  `recipient` varchar(50) NOT NULL DEFAULT '0',
  `message` varchar(1000) NOT NULL,
  `link` varchar(1000) NOT NULL,
  `msg_id` varchar(100) NOT NULL,
  `done` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`sms_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1898 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for view authumra_offline2017.summary_1441
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `summary_1441` (
	`client_id` INT(11) NULL,
	`Company` VARCHAR(100) NULL COLLATE 'utf8mb3_general_ci',
	`Country` VARCHAR(50) NULL COLLATE 'utf8mb3_bin',
	`Counter` BIGINT(21) NOT NULL
) ENGINE=MyISAM;

-- Dumping structure for table authumra_offline2017.tawaf_log
CREATE TABLE IF NOT EXISTS `tawaf_log` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `hardwareid` varchar(50) NOT NULL DEFAULT '0',
  `group_id` int(11) NOT NULL,
  `grp_name` varchar(50) NOT NULL,
  `grp_cntry` int(11) NOT NULL,
  `grp_count` int(11) NOT NULL,
  `token` varchar(100) NOT NULL,
  `ea_id` int(11) NOT NULL,
  `uo_id` int(11) NOT NULL,
  `emb_id` int(11) NOT NULL,
  `body` longtext NOT NULL,
  `response` varchar(1000) NOT NULL,
  `create_stamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`log_id`)
) ENGINE=InnoDB AUTO_INCREMENT=804 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_agents
CREATE TABLE IF NOT EXISTS `tbl_agents` (
  `agent_id` int(11) NOT NULL AUTO_INCREMENT,
  `agent_name` varchar(100) DEFAULT NULL,
  `agent_code` int(11) DEFAULT NULL,
  `embassy_user` varchar(50) DEFAULT NULL,
  `dongle_id` int(11) DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`agent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_applications
CREATE TABLE IF NOT EXISTS `tbl_applications` (
  `PR_ID` int(1) NOT NULL AUTO_INCREMENT,
  `id` int(1) NOT NULL,
  `Application_Name` varchar(15) NOT NULL,
  `visible` int(11) NOT NULL,
  PRIMARY KEY (`PR_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_clients
CREATE TABLE IF NOT EXISTS `tbl_clients` (
  `Id` int(10) NOT NULL AUTO_INCREMENT,
  `CompanyName` varchar(100) NOT NULL,
  `Reseller` varchar(10) NOT NULL DEFAULT 'E',
  `PersonIncharge` varchar(100) DEFAULT NULL,
  `Country` int(10) DEFAULT 20,
  `City` varchar(35) DEFAULT NULL,
  `Telephone` varchar(100) DEFAULT NULL,
  `Email` varchar(100) DEFAULT NULL,
  `MSN` varchar(30) DEFAULT NULL,
  `Purchase_Date` varchar(10) NOT NULL,
  `Renew_Date` varchar(10) NOT NULL,
  `connection_id` varchar(50) DEFAULT NULL,
  `Start_Balance` int(10) DEFAULT 0,
  `Message` text NOT NULL,
  `Barcode_Enabled` tinyint(1) unsigned zerofill DEFAULT NULL,
  `safa_ea_id` int(11) DEFAULT NULL,
  `activate_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `register` mediumtext DEFAULT NULL,
  `hidden_balance` int(11) DEFAULT 0,
  `credit_warning` int(11) NOT NULL DEFAULT 0,
  `status` int(11) NOT NULL DEFAULT 1,
  `ministry_enabled` int(11) NOT NULL DEFAULT 0,
  `cloud_enabled` tinyint(4) NOT NULL DEFAULT 1,
  `autoupdate_enabled` tinyint(4) NOT NULL DEFAULT 1,
  `alert_enabled` tinyint(4) NOT NULL DEFAULT 1,
  `license_enabled` tinyint(4) NOT NULL DEFAULT 0,
  `free_license` tinyint(4) NOT NULL DEFAULT 1,
  `b2c_license` tinyint(4) NOT NULL DEFAULT 1,
  `max_license` int(11) NOT NULL DEFAULT 3,
  PRIMARY KEY (`Id`),
  UNIQUE KEY `safa_ea_id` (`safa_ea_id`),
  UNIQUE KEY `Client` (`CompanyName`,`Country`)
) ENGINE=InnoDB AUTO_INCREMENT=2911 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_clients_applications
CREATE TABLE IF NOT EXISTS `tbl_clients_applications` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `App_Id` int(1) NOT NULL,
  `Client_id` int(10) NOT NULL,
  `availability` int(1) DEFAULT NULL,
  `Blocked` int(1) DEFAULT 0,
  `Version` varchar(10) DEFAULT NULL,
  `User` varchar(10) DEFAULT NULL,
  `serial` int(12) DEFAULT NULL,
  `Last_Counter` int(10) DEFAULT 0,
  `Stop_At` int(11) DEFAULT 0,
  `Time_stamp` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `Index 4` (`App_Id`,`Client_id`),
  KEY `FK_tbl_clients_applications_tbl_clients` (`Client_id`),
  KEY `client_id_app` (`App_Id`,`Client_id`),
  CONSTRAINT `FK_tbl_clients_applications_tbl_clients` FOREIGN KEY (`Client_id`) REFERENCES `tbl_clients` (`Id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=24120 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_clients_applications_2
CREATE TABLE IF NOT EXISTS `tbl_clients_applications_2` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `App_Id` int(1) NOT NULL,
  `Client_id` int(10) NOT NULL,
  `availability` int(1) DEFAULT NULL,
  `Blocked` int(1) DEFAULT 0,
  `Version` varchar(10) DEFAULT NULL,
  `User` varchar(10) DEFAULT NULL,
  `serial` int(12) DEFAULT NULL,
  `Last_Counter` int(10) DEFAULT 0,
  `Stop_At` int(11) DEFAULT NULL,
  `Time_stamp` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `FK_tbl_clients_applications_tbl_clients` (`Client_id`) USING BTREE,
  KEY `client_id_app` (`App_Id`,`Client_id`) USING BTREE,
  CONSTRAINT `tbl_clients_applications_2_ibfk_1` FOREIGN KEY (`Client_id`) REFERENCES `tbl_clients` (`Id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=23990 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_clients_applications_log
CREATE TABLE IF NOT EXISTS `tbl_clients_applications_log` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `App_Id` int(1) NOT NULL,
  `Client_id` int(10) NOT NULL,
  `Last_Counter` int(10) NOT NULL,
  `Stop_At` int(10) NOT NULL,
  `Old_Stop_At` int(10) NOT NULL,
  `Time_stamp` datetime NOT NULL,
  PRIMARY KEY (`log_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19522 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_clients_cloud
CREATE TABLE IF NOT EXISTS `tbl_clients_cloud` (
  `client_id` int(11) DEFAULT NULL,
  `data_username` varchar(50) DEFAULT NULL,
  `data_password` varchar(50) DEFAULT NULL,
  `data_db` varchar(50) DEFAULT NULL,
  `ftp_username` varchar(50) DEFAULT NULL,
  `ftp_password` varchar(50) DEFAULT NULL,
  `enabled` int(11) DEFAULT 1,
  UNIQUE KEY `unique` (`client_id`),
  CONSTRAINT `FK_tbl_clients_cloud_tbl_clients` FOREIGN KEY (`client_id`) REFERENCES `tbl_clients` (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_client_uasp
CREATE TABLE IF NOT EXISTS `tbl_client_uasp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL DEFAULT 0,
  `uasp_list` set('BAU','WTU','GAMA','TAWAF') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_countries
CREATE TABLE IF NOT EXISTS `tbl_countries` (
  `CNTRY_ID` int(11) NOT NULL,
  `CNTRY_NAME_LA` varchar(50) DEFAULT NULL,
  `CNTRY_NAME_AR` varchar(50) DEFAULT NULL,
  `CNTRY_VISIBLE_STATUS` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`CNTRY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_dongles
CREATE TABLE IF NOT EXISTS `tbl_dongles` (
  `Id` int(10) NOT NULL AUTO_INCREMENT,
  `Client_id` int(10) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=58489 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_privileges
CREATE TABLE IF NOT EXISTS `tbl_privileges` (
  `ID` tinyint(1) NOT NULL AUTO_INCREMENT,
  `Privilege_Name` varchar(50) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_requests
CREATE TABLE IF NOT EXISTS `tbl_requests` (
  `Id` int(10) NOT NULL AUTO_INCREMENT,
  `prog` varchar(10) DEFAULT NULL,
  `version` varchar(10) DEFAULT NULL,
  `user` varchar(25) DEFAULT NULL,
  `password` varchar(25) DEFAULT NULL,
  `serial` int(10) DEFAULT NULL,
  `counter` int(10) DEFAULT NULL,
  `Client_id` int(10) DEFAULT NULL,
  `Mac` varchar(50) DEFAULT NULL,
  `ip_address` varchar(50) DEFAULT NULL,
  `Response` varchar(250) DEFAULT NULL,
  `TimeStamp` timestamp NOT NULL DEFAULT current_timestamp(),
  `wallet` varchar(50) DEFAULT NULL,
  `request` varchar(2000) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=285324 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_requests_1445
CREATE TABLE IF NOT EXISTS `tbl_requests_1445` (
  `Id` int(10) NOT NULL AUTO_INCREMENT,
  `prog` varchar(10) DEFAULT NULL,
  `version` varchar(10) DEFAULT NULL,
  `user` varchar(25) DEFAULT NULL,
  `password` varchar(25) DEFAULT NULL,
  `serial` int(10) DEFAULT NULL,
  `counter` int(10) DEFAULT NULL,
  `Client_id` int(10) DEFAULT NULL,
  `Mac` varchar(50) DEFAULT NULL,
  `ip_address` varchar(50) DEFAULT NULL,
  `Response` varchar(250) DEFAULT NULL,
  `TimeStamp` timestamp NOT NULL DEFAULT current_timestamp(),
  `wallet` varchar(50) DEFAULT NULL,
  `request` varchar(2000) DEFAULT NULL,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1313230 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_requests_39
CREATE TABLE IF NOT EXISTS `tbl_requests_39` (
  `Id` int(10) NOT NULL AUTO_INCREMENT,
  `prog` varchar(10) DEFAULT NULL,
  `version` varchar(10) DEFAULT NULL,
  `user` varchar(25) DEFAULT NULL,
  `password` varchar(25) DEFAULT NULL,
  `serial` int(10) DEFAULT NULL,
  `counter` int(10) DEFAULT NULL,
  `Client_id` int(10) DEFAULT NULL,
  `Mac` varchar(50) DEFAULT NULL,
  `Response` varchar(250) DEFAULT NULL,
  `TimeStamp` timestamp NOT NULL DEFAULT current_timestamp(),
  `wallet` varchar(50) DEFAULT NULL,
  `request` varchar(2000) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=MyISAM AUTO_INCREMENT=209894 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_requests_40
CREATE TABLE IF NOT EXISTS `tbl_requests_40` (
  `Id` int(10) NOT NULL AUTO_INCREMENT,
  `prog` varchar(10) DEFAULT NULL,
  `version` varchar(10) DEFAULT NULL,
  `user` varchar(25) DEFAULT NULL,
  `password` varchar(25) DEFAULT NULL,
  `serial` int(10) DEFAULT NULL,
  `counter` int(10) DEFAULT NULL,
  `Client_id` int(10) DEFAULT NULL,
  `Mac` varchar(50) DEFAULT NULL,
  `ip_address` varchar(50) DEFAULT NULL,
  `Response` varchar(250) DEFAULT NULL,
  `TimeStamp` timestamp NOT NULL DEFAULT current_timestamp(),
  `wallet` varchar(50) DEFAULT NULL,
  `request` varchar(2000) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=MyISAM AUTO_INCREMENT=298866 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_requests_41
CREATE TABLE IF NOT EXISTS `tbl_requests_41` (
  `Id` int(10) NOT NULL AUTO_INCREMENT,
  `prog` varchar(10) DEFAULT NULL,
  `version` varchar(10) DEFAULT NULL,
  `user` varchar(25) DEFAULT NULL,
  `password` varchar(25) DEFAULT NULL,
  `serial` int(10) DEFAULT NULL,
  `counter` int(10) DEFAULT NULL,
  `Client_id` int(10) DEFAULT NULL,
  `Mac` varchar(50) DEFAULT NULL,
  `ip_address` varchar(50) DEFAULT NULL,
  `Response` varchar(250) DEFAULT NULL,
  `TimeStamp` timestamp NOT NULL DEFAULT current_timestamp(),
  `wallet` varchar(50) DEFAULT NULL,
  `request` varchar(2000) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=MyISAM AUTO_INCREMENT=376464 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_uos
CREATE TABLE IF NOT EXISTS `tbl_uos` (
  `uo_id` int(11) NOT NULL,
  `name_ar` varchar(200) NOT NULL,
  `name_la` varchar(200) NOT NULL,
  `uasp_id` int(11) DEFAULT NULL,
  `tel_no` varchar(25) DEFAULT NULL,
  `fax_no` varchar(25) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `website` varchar(100) DEFAULT NULL,
  `address_ar` varchar(250) DEFAULT NULL,
  `address_la` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`uo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_users
CREATE TABLE IF NOT EXISTS `tbl_users` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `User_Name` varchar(30) NOT NULL,
  `Country` varchar(10) NOT NULL,
  `Password` varchar(32) NOT NULL,
  `Type` varchar(15) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `User` (`User_Name`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_user_privileges
CREATE TABLE IF NOT EXISTS `tbl_user_privileges` (
  `ID` tinyint(2) NOT NULL AUTO_INCREMENT,
  `Privilege_ID` tinyint(2) NOT NULL,
  `View` tinyint(1) NOT NULL DEFAULT 0,
  `Add` tinyint(1) NOT NULL DEFAULT 0,
  `Delete` tinyint(1) NOT NULL DEFAULT 0,
  `Edit` varchar(2) NOT NULL DEFAULT '0' COMMENT ' Edit Client(All / Contact)',
  `User_ID` int(10) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.tbl_wallet
CREATE TABLE IF NOT EXISTS `tbl_wallet` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `wallet` varchar(50) NOT NULL,
  PRIMARY KEY (`Id`),
  UNIQUE KEY `Index 2` (`client_id`,`wallet`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.visas_1438
CREATE TABLE IF NOT EXISTS `visas_1438` (
  `visa_id` int(11) NOT NULL AUTO_INCREMENT,
  `dongle` int(11) NOT NULL DEFAULT 0,
  `client_id` int(11) NOT NULL DEFAULT 0,
  `user` varchar(25) NOT NULL DEFAULT '0',
  `pass` varchar(25) NOT NULL DEFAULT '0',
  `counter` varchar(25) NOT NULL DEFAULT '0',
  `code` varchar(100) NOT NULL DEFAULT '0',
  `mofa` varchar(25) NOT NULL DEFAULT '0',
  `enumber` varchar(25) NOT NULL DEFAULT '0',
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) DEFAULT NULL,
  `link` varchar(500) NOT NULL,
  `type` varchar(5) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`visa_id`)
) ENGINE=InnoDB AUTO_INCREMENT=174609 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci COMMENT='31639+';

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.visas_1439
CREATE TABLE IF NOT EXISTS `visas_1439` (
  `visa_id` int(11) NOT NULL AUTO_INCREMENT,
  `dongle` int(11) NOT NULL DEFAULT 0,
  `client_id` int(11) NOT NULL DEFAULT 0,
  `user` varchar(25) NOT NULL DEFAULT '0',
  `pass` varchar(25) NOT NULL DEFAULT '0',
  `counter` varchar(25) NOT NULL DEFAULT '0',
  `code` varchar(100) NOT NULL DEFAULT '0',
  `mofa` varchar(25) NOT NULL DEFAULT '0',
  `enumber` varchar(25) NOT NULL DEFAULT '0',
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) DEFAULT 0,
  `link` varchar(500) NOT NULL,
  `type` varchar(5) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`visa_id`)
) ENGINE=InnoDB AUTO_INCREMENT=197340 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.visas_1440
CREATE TABLE IF NOT EXISTS `visas_1440` (
  `visa_id` int(11) NOT NULL AUTO_INCREMENT,
  `dongle` int(11) NOT NULL DEFAULT 0,
  `client_id` int(11) NOT NULL DEFAULT 0,
  `user` varchar(25) NOT NULL DEFAULT '0',
  `pass` varchar(25) NOT NULL DEFAULT '0',
  `counter` varchar(25) NOT NULL DEFAULT '0',
  `code` varchar(100) NOT NULL DEFAULT '0',
  `mofa` varchar(25) NOT NULL DEFAULT '0',
  `enumber` varchar(25) NOT NULL DEFAULT '0',
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) DEFAULT 0,
  `link` varchar(500) NOT NULL,
  `type` varchar(5) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`visa_id`)
) ENGINE=InnoDB AUTO_INCREMENT=268147 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.visas_1441
CREATE TABLE IF NOT EXISTS `visas_1441` (
  `visa_id` int(11) NOT NULL AUTO_INCREMENT,
  `dongle` int(11) NOT NULL DEFAULT 0,
  `client_id` int(11) DEFAULT NULL,
  `user` varchar(25) NOT NULL DEFAULT '0',
  `pass` varchar(25) NOT NULL DEFAULT '0',
  `counter` varchar(25) NOT NULL DEFAULT '0',
  `code` varchar(100) NOT NULL DEFAULT '0',
  `mofa` varchar(25) NOT NULL DEFAULT '0',
  `enumber` varchar(25) NOT NULL DEFAULT '0',
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) DEFAULT 0,
  `link` varchar(500) NOT NULL,
  `type` varchar(5) DEFAULT NULL,
  `status` varchar(25) DEFAULT '',
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`visa_id`),
  KEY `FK_visas_1441_tbl_clients` (`client_id`),
  CONSTRAINT `FK_visas_1441_tbl_clients` FOREIGN KEY (`client_id`) REFERENCES `tbl_clients` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=440321 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.visas_1442
CREATE TABLE IF NOT EXISTS `visas_1442` (
  `visa_id` int(11) NOT NULL AUTO_INCREMENT,
  `dongle` int(11) NOT NULL DEFAULT 0,
  `client_id` int(11) DEFAULT NULL,
  `user` varchar(25) NOT NULL DEFAULT '0',
  `pass` varchar(25) NOT NULL DEFAULT '0',
  `counter` varchar(25) NOT NULL DEFAULT '0',
  `code` varchar(100) NOT NULL DEFAULT '0',
  `mofa` varchar(25) NOT NULL DEFAULT '0',
  `enumber` varchar(25) NOT NULL DEFAULT '0',
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) DEFAULT 0,
  `link` varchar(500) NOT NULL,
  `type` varchar(5) DEFAULT NULL,
  `status` varchar(25) DEFAULT '',
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`visa_id`) USING BTREE,
  KEY `FK_visas_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `VisaU` (`code`,`nationality`,`ppno`,`mofa`,`enumber`),
  CONSTRAINT `visas_1442_ibfk_1` FOREIGN KEY (`client_id`) REFERENCES `tbl_clients` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=450468 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.visas_1443
CREATE TABLE IF NOT EXISTS `visas_1443` (
  `visa_id` int(11) NOT NULL AUTO_INCREMENT,
  `dongle` int(11) NOT NULL DEFAULT 0,
  `client_id` int(11) DEFAULT NULL,
  `user` varchar(25) NOT NULL DEFAULT '0',
  `pass` varchar(25) NOT NULL DEFAULT '0',
  `counter` varchar(25) NOT NULL DEFAULT '0',
  `code` varchar(100) NOT NULL DEFAULT '0',
  `mofa` varchar(25) NOT NULL DEFAULT '0',
  `enumber` varchar(25) NOT NULL DEFAULT '0',
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) DEFAULT 0,
  `link` varchar(500) NOT NULL,
  `type` varchar(5) DEFAULT NULL,
  `status` varchar(25) DEFAULT '',
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`visa_id`) USING BTREE,
  KEY `FK_visas_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `VisaU` (`code`,`nationality`,`ppno`,`mofa`,`enumber`) USING BTREE,
  CONSTRAINT `visas_1443_ibfk_1` FOREIGN KEY (`client_id`) REFERENCES `tbl_clients` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=587159 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.visas_1444
CREATE TABLE IF NOT EXISTS `visas_1444` (
  `visa_id` int(11) NOT NULL AUTO_INCREMENT,
  `dongle` int(11) NOT NULL DEFAULT 0,
  `client_id` int(11) DEFAULT NULL,
  `user` varchar(25) NOT NULL DEFAULT '0',
  `pass` varchar(25) NOT NULL DEFAULT '0',
  `counter` varchar(25) NOT NULL DEFAULT '0',
  `code` varchar(100) NOT NULL DEFAULT '0',
  `mofa` varchar(25) NOT NULL DEFAULT '0',
  `enumber` varchar(25) NOT NULL DEFAULT '0',
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) DEFAULT 0,
  `link` varchar(500) NOT NULL,
  `type` varchar(5) DEFAULT NULL,
  `status` varchar(25) DEFAULT '',
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`visa_id`) USING BTREE,
  KEY `FK_visas_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `VisaU` (`code`,`nationality`,`ppno`,`mofa`,`enumber`) USING BTREE,
  KEY `client_type` (`client_id`,`type`),
  CONSTRAINT `visas_1444_ibfk_1` FOREIGN KEY (`client_id`) REFERENCES `tbl_clients` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=1412758 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.visas_1445
CREATE TABLE IF NOT EXISTS `visas_1445` (
  `visa_id` int(11) NOT NULL AUTO_INCREMENT,
  `dongle` int(11) NOT NULL DEFAULT 0,
  `client_id` int(11) DEFAULT NULL,
  `user` varchar(25) NOT NULL DEFAULT '0',
  `pass` varchar(25) NOT NULL DEFAULT '0',
  `counter` varchar(25) NOT NULL DEFAULT '0',
  `code` varchar(100) NOT NULL DEFAULT '0',
  `mofa` varchar(25) NOT NULL DEFAULT '0',
  `enumber` varchar(25) NOT NULL DEFAULT '0',
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) DEFAULT 0,
  `link` varchar(500) NOT NULL,
  `type` varchar(5) DEFAULT NULL,
  `status` varchar(25) DEFAULT '',
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`visa_id`) USING BTREE,
  KEY `FK_visas_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `VisaU` (`code`,`nationality`,`ppno`,`mofa`,`enumber`) USING BTREE,
  KEY `client_type` (`client_id`,`type`),
  CONSTRAINT `visas_1445_ibfk_1` FOREIGN KEY (`client_id`) REFERENCES `tbl_clients` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=1456204 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.visas_1446
CREATE TABLE IF NOT EXISTS `visas_1446` (
  `visa_id` int(11) NOT NULL AUTO_INCREMENT,
  `dongle` int(11) NOT NULL DEFAULT 0,
  `client_id` int(11) DEFAULT NULL,
  `user` varchar(25) NOT NULL DEFAULT '0',
  `pass` varchar(25) NOT NULL DEFAULT '0',
  `counter` varchar(25) NOT NULL DEFAULT '0',
  `code` varchar(100) NOT NULL DEFAULT '0',
  `mofa` varchar(25) NOT NULL DEFAULT '0',
  `enumber` varchar(25) NOT NULL DEFAULT '0',
  `ppno` varchar(25) NOT NULL,
  `nationality` int(11) DEFAULT 0,
  `link` varchar(500) NOT NULL,
  `type` varchar(5) DEFAULT NULL,
  `visanumber` varchar(15) DEFAULT NULL,
  `status` varchar(25) DEFAULT '',
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`visa_id`) USING BTREE,
  KEY `FK_visas_1441_tbl_clients` (`client_id`) USING BTREE,
  KEY `VisaU` (`code`,`nationality`,`ppno`,`mofa`,`enumber`) USING BTREE,
  KEY `client_type` (`client_id`,`type`) USING BTREE,
  CONSTRAINT `visas_1446_ibfk_1` FOREIGN KEY (`client_id`) REFERENCES `tbl_clients` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=1471085 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=COMPACT;

-- Data exporting was unselected.

-- Dumping structure for table authumra_offline2017.visa_types
CREATE TABLE IF NOT EXISTS `visa_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `Index 2` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- Data exporting was unselected.

-- Dumping structure for trigger authumra_offline2017.tbl_clients_applications_before_update
SET @OLDTMP_SQL_MODE=@@SQL_MODE, SQL_MODE='';
DELIMITER //
CREATE TRIGGER `authumra_offline2017`.`tbl_clients_applications_before_update` BEFORE UPDATE ON `authumra_offline2017`.`tbl_clients_applications` FOR EACH ROW BEGIN
  if new.Stop_At <> old.Stop_At then 
    insert into tbl_clients_applications_log (`App_id`, `Client_id`, `Last_Counter`, `Stop_At`, `Old_Stop_At`, `Time_stamp`) values (old.App_Id, old.Client_id, old.Last_Counter, new.Stop_At, old.Stop_At, NOW());
  end if;
END//
DELIMITER ;
SET SQL_MODE=@OLDTMP_SQL_MODE;

-- Dumping structure for trigger authumra_offline2017.update_counters
SET @OLDTMP_SQL_MODE=@@SQL_MODE, SQL_MODE='STRICT_TRANS_TABLES,NO_ENGINE_SUBSTITUTION';
DELIMITER //
CREATE TRIGGER `authumra_offline2017`.`update_counters` AFTER INSERT ON `authumra_offline2017`.`tbl_requests` FOR EACH ROW BEGIN
  update tbl_clients_applications 
    set `last_counter`=new.counter, `time_stamp` = NOW(), `user`=new.user,`version`=new.version,serial=new.serial
    where app_id=(select Id from tbl_applications where application_name=new.prog) and
      client_id = new.Client_id;
  update crm_ea_machines set crm_ea_machines.last_access = now(), crm_ea_machines.version = new.version
    where crm_ea_machines.hash = new.Mac;
END//
DELIMITER ;
SET SQL_MODE=@OLDTMP_SQL_MODE;

-- Dumping structure for trigger authumra_offline2017.visas_1446_before_insert
SET @OLDTMP_SQL_MODE=@@SQL_MODE, SQL_MODE='';
DELIMITER //
CREATE TRIGGER `authumra_offline2017`.`visas_1446_before_insert` BEFORE INSERT ON `authumra_offline2017`.`visas_1446` FOR EACH ROW BEGIN
  INSERT INTO `authumra_visas`.`visas` (`dongle`, `client_id`, `user`, `pass`, `counter`, `code`, `mofa`, `enumber`, `ppno`, `nationality`, `link`, `status`, `type`) VALUES (NEW.dongle,
   NEW.client_id, NEW.`user`, NEW.pass, NEW.counter, NEW.code, NEW.mofa, NEW.enumber, NEW.ppno, NEW.nationality, NEW.link, NEW.status, NEW.`type`);
END//
DELIMITER ;
SET SQL_MODE=@OLDTMP_SQL_MODE;

-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `captcha_view`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `captcha_view` AS select count(0) AS `COUNT(*)`,`captcha_requests`.`license` AS `license`,`C`.`CompanyName` AS `CompanyName` from ((`captcha_requests` left join `license` `l` on(`l`.`license_code` = `captcha_requests`.`license`)) left join `tbl_clients` `C` on(`C`.`Id` = `l`.`client_id`)) where `captcha_requests`.`created_at` > '2023-07-05' group by `captcha_requests`.`license`;

-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `clients_version`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `clients_version` AS select distinct `tbl_clients`.`Id` AS `Id`,`tbl_clients`.`CompanyName` AS `companyname`,`tbl_clients_applications`.`Version` AS `version` from (`tbl_clients` left join `tbl_clients_applications` on(`tbl_clients_applications`.`Client_id` = `tbl_clients`.`Id`)) where `tbl_clients_applications`.`App_Id` = 6 order by `tbl_clients_applications`.`Version` desc;

-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `egypt_visas`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `egypt_visas` AS select `tbl_clients`.`Id` AS `Id`,`tbl_clients`.`CompanyName` AS `companyname`,count(0) AS `counter` from (`visas_1443` left join `tbl_clients` on(`tbl_clients`.`Id` = `visas_1443`.`client_id`)) where `tbl_clients`.`Country` = 20 and `visas_1443`.`type` <> 3 group by `tbl_clients`.`CompanyName` order by count(0) desc;

-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `hajj_1439`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `hajj_1439` AS select count(0) AS `count(*)`,`passports_1439`.`client_id` AS `client_id`,`tbl_clients`.`CompanyName` AS `CompanyName`,`tbl_clients`.`Country` AS `Country` from (`passports_1439` left join `tbl_clients` on(`tbl_clients`.`Id` = `passports_1439`.`client_id`)) where `passports_1439`.`type` = 1 group by `passports_1439`.`client_id` order by count(0) desc;

-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `passports_1445_view`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `passports_1445_view` AS select `passports_1445_July_2023`.`passport_id` AS `passport_id`,`passports_1445_July_2023`.`client_id` AS `client_id`,`passports_1445_July_2023`.`pilgrimId` AS `pilgrimId`,`passports_1445_July_2023`.`ppno` AS `ppno`,`passports_1445_July_2023`.`nationality` AS `nationality`,`passports_1445_July_2023`.`mofa` AS `mofa`,`passports_1445_July_2023`.`type` AS `type`,`passports_1445_July_2023`.`Firstname` AS `Firstname`,`passports_1445_July_2023`.`Secondname` AS `Secondname`,`passports_1445_July_2023`.`Thirdname` AS `Thirdname`,`passports_1445_July_2023`.`Lastname` AS `Lastname`,`passports_1445_July_2023`.`AFirstname` AS `AFirstname`,`passports_1445_July_2023`.`ASecondname` AS `ASecondname`,`passports_1445_July_2023`.`AThirdname` AS `AThirdname`,`passports_1445_July_2023`.`ALastname` AS `ALastname`,`passports_1445_July_2023`.`link` AS `link`,`passports_1445_July_2023`.`code` AS `code`,`passports_1445_July_2023`.`machine` AS `machine`,`passports_1445_July_2023`.`timestamp` AS `timestamp` from `passports_1445_July_2023` union select `passports_1445_August_2023`.`passport_id` AS `passport_id`,`passports_1445_August_2023`.`client_id` AS `client_id`,`passports_1445_August_2023`.`pilgrimId` AS `pilgrimId`,`passports_1445_August_2023`.`ppno` AS `ppno`,`passports_1445_August_2023`.`nationality` AS `nationality`,`passports_1445_August_2023`.`mofa` AS `mofa`,`passports_1445_August_2023`.`type` AS `type`,`passports_1445_August_2023`.`Firstname` AS `Firstname`,`passports_1445_August_2023`.`Secondname` AS `Secondname`,`passports_1445_August_2023`.`Thirdname` AS `Thirdname`,`passports_1445_August_2023`.`Lastname` AS `Lastname`,`passports_1445_August_2023`.`AFirstname` AS `AFirstname`,`passports_1445_August_2023`.`ASecondname` AS `ASecondname`,`passports_1445_August_2023`.`AThirdname` AS `AThirdname`,`passports_1445_August_2023`.`ALastname` AS `ALastname`,`passports_1445_August_2023`.`link` AS `link`,`passports_1445_August_2023`.`code` AS `code`,`passports_1445_August_2023`.`machine` AS `machine`,`passports_1445_August_2023`.`timestamp` AS `timestamp` from `passports_1445_August_2023` union select `passports_1445_September_2023`.`passport_id` AS `passport_id`,`passports_1445_September_2023`.`client_id` AS `client_id`,`passports_1445_September_2023`.`pilgrimId` AS `pilgrimId`,`passports_1445_September_2023`.`ppno` AS `ppno`,`passports_1445_September_2023`.`nationality` AS `nationality`,`passports_1445_September_2023`.`mofa` AS `mofa`,`passports_1445_September_2023`.`type` AS `type`,`passports_1445_September_2023`.`Firstname` AS `Firstname`,`passports_1445_September_2023`.`Secondname` AS `Secondname`,`passports_1445_September_2023`.`Thirdname` AS `Thirdname`,`passports_1445_September_2023`.`Lastname` AS `Lastname`,`passports_1445_September_2023`.`AFirstname` AS `AFirstname`,`passports_1445_September_2023`.`ASecondname` AS `ASecondname`,`passports_1445_September_2023`.`AThirdname` AS `AThirdname`,`passports_1445_September_2023`.`ALastname` AS `ALastname`,`passports_1445_September_2023`.`link` AS `link`,`passports_1445_September_2023`.`code` AS `code`,`passports_1445_September_2023`.`machine` AS `machine`,`passports_1445_September_2023`.`timestamp` AS `timestamp` from `passports_1445_September_2023` union select `passports_1445_October_2023`.`passport_id` AS `passport_id`,`passports_1445_October_2023`.`client_id` AS `client_id`,`passports_1445_October_2023`.`pilgrimId` AS `pilgrimId`,`passports_1445_October_2023`.`ppno` AS `ppno`,`passports_1445_October_2023`.`nationality` AS `nationality`,`passports_1445_October_2023`.`mofa` AS `mofa`,`passports_1445_October_2023`.`type` AS `type`,`passports_1445_October_2023`.`Firstname` AS `Firstname`,`passports_1445_October_2023`.`Secondname` AS `Secondname`,`passports_1445_October_2023`.`Thirdname` AS `Thirdname`,`passports_1445_October_2023`.`Lastname` AS `Lastname`,`passports_1445_October_2023`.`AFirstname` AS `AFirstname`,`passports_1445_October_2023`.`ASecondname` AS `ASecondname`,`passports_1445_October_2023`.`AThirdname` AS `AThirdname`,`passports_1445_October_2023`.`ALastname` AS `ALastname`,`passports_1445_October_2023`.`link` AS `link`,`passports_1445_October_2023`.`code` AS `code`,`passports_1445_October_2023`.`machine` AS `machine`,`passports_1445_October_2023`.`timestamp` AS `timestamp` from `passports_1445_October_2023` union select `passports_1445_November_2023`.`passport_id` AS `passport_id`,`passports_1445_November_2023`.`client_id` AS `client_id`,`passports_1445_November_2023`.`pilgrimId` AS `pilgrimId`,`passports_1445_November_2023`.`ppno` AS `ppno`,`passports_1445_November_2023`.`nationality` AS `nationality`,`passports_1445_November_2023`.`mofa` AS `mofa`,`passports_1445_November_2023`.`type` AS `type`,`passports_1445_November_2023`.`Firstname` AS `Firstname`,`passports_1445_November_2023`.`Secondname` AS `Secondname`,`passports_1445_November_2023`.`Thirdname` AS `Thirdname`,`passports_1445_November_2023`.`Lastname` AS `Lastname`,`passports_1445_November_2023`.`AFirstname` AS `AFirstname`,`passports_1445_November_2023`.`ASecondname` AS `ASecondname`,`passports_1445_November_2023`.`AThirdname` AS `AThirdname`,`passports_1445_November_2023`.`ALastname` AS `ALastname`,`passports_1445_November_2023`.`link` AS `link`,`passports_1445_November_2023`.`code` AS `code`,`passports_1445_November_2023`.`machine` AS `machine`,`passports_1445_November_2023`.`timestamp` AS `timestamp` from `passports_1445_November_2023` union select `passports_1445_December_2023`.`passport_id` AS `passport_id`,`passports_1445_December_2023`.`client_id` AS `client_id`,`passports_1445_December_2023`.`pilgrimId` AS `pilgrimId`,`passports_1445_December_2023`.`ppno` AS `ppno`,`passports_1445_December_2023`.`nationality` AS `nationality`,`passports_1445_December_2023`.`mofa` AS `mofa`,`passports_1445_December_2023`.`type` AS `type`,`passports_1445_December_2023`.`Firstname` AS `Firstname`,`passports_1445_December_2023`.`Secondname` AS `Secondname`,`passports_1445_December_2023`.`Thirdname` AS `Thirdname`,`passports_1445_December_2023`.`Lastname` AS `Lastname`,`passports_1445_December_2023`.`AFirstname` AS `AFirstname`,`passports_1445_December_2023`.`ASecondname` AS `ASecondname`,`passports_1445_December_2023`.`AThirdname` AS `AThirdname`,`passports_1445_December_2023`.`ALastname` AS `ALastname`,`passports_1445_December_2023`.`link` AS `link`,`passports_1445_December_2023`.`code` AS `code`,`passports_1445_December_2023`.`machine` AS `machine`,`passports_1445_December_2023`.`timestamp` AS `timestamp` from `passports_1445_December_2023` union select `passports_1445_January_2024`.`passport_id` AS `passport_id`,`passports_1445_January_2024`.`client_id` AS `client_id`,`passports_1445_January_2024`.`pilgrimId` AS `pilgrimId`,`passports_1445_January_2024`.`ppno` AS `ppno`,`passports_1445_January_2024`.`nationality` AS `nationality`,`passports_1445_January_2024`.`mofa` AS `mofa`,`passports_1445_January_2024`.`type` AS `type`,`passports_1445_January_2024`.`Firstname` AS `Firstname`,`passports_1445_January_2024`.`Secondname` AS `Secondname`,`passports_1445_January_2024`.`Thirdname` AS `Thirdname`,`passports_1445_January_2024`.`Lastname` AS `Lastname`,`passports_1445_January_2024`.`AFirstname` AS `AFirstname`,`passports_1445_January_2024`.`ASecondname` AS `ASecondname`,`passports_1445_January_2024`.`AThirdname` AS `AThirdname`,`passports_1445_January_2024`.`ALastname` AS `ALastname`,`passports_1445_January_2024`.`link` AS `link`,`passports_1445_January_2024`.`code` AS `code`,`passports_1445_January_2024`.`machine` AS `machine`,`passports_1445_January_2024`.`timestamp` AS `timestamp` from `passports_1445_January_2024` union select `passports_1445_February_2024`.`passport_id` AS `passport_id`,`passports_1445_February_2024`.`client_id` AS `client_id`,`passports_1445_February_2024`.`pilgrimId` AS `pilgrimId`,`passports_1445_February_2024`.`ppno` AS `ppno`,`passports_1445_February_2024`.`nationality` AS `nationality`,`passports_1445_February_2024`.`mofa` AS `mofa`,`passports_1445_February_2024`.`type` AS `type`,`passports_1445_February_2024`.`Firstname` AS `Firstname`,`passports_1445_February_2024`.`Secondname` AS `Secondname`,`passports_1445_February_2024`.`Thirdname` AS `Thirdname`,`passports_1445_February_2024`.`Lastname` AS `Lastname`,`passports_1445_February_2024`.`AFirstname` AS `AFirstname`,`passports_1445_February_2024`.`ASecondname` AS `ASecondname`,`passports_1445_February_2024`.`AThirdname` AS `AThirdname`,`passports_1445_February_2024`.`ALastname` AS `ALastname`,`passports_1445_February_2024`.`link` AS `link`,`passports_1445_February_2024`.`code` AS `code`,`passports_1445_February_2024`.`machine` AS `machine`,`passports_1445_February_2024`.`timestamp` AS `timestamp` from `passports_1445_February_2024` union select `passports_1445_March_2024`.`passport_id` AS `passport_id`,`passports_1445_March_2024`.`client_id` AS `client_id`,`passports_1445_March_2024`.`pilgrimId` AS `pilgrimId`,`passports_1445_March_2024`.`ppno` AS `ppno`,`passports_1445_March_2024`.`nationality` AS `nationality`,`passports_1445_March_2024`.`mofa` AS `mofa`,`passports_1445_March_2024`.`type` AS `type`,`passports_1445_March_2024`.`Firstname` AS `Firstname`,`passports_1445_March_2024`.`Secondname` AS `Secondname`,`passports_1445_March_2024`.`Thirdname` AS `Thirdname`,`passports_1445_March_2024`.`Lastname` AS `Lastname`,`passports_1445_March_2024`.`AFirstname` AS `AFirstname`,`passports_1445_March_2024`.`ASecondname` AS `ASecondname`,`passports_1445_March_2024`.`AThirdname` AS `AThirdname`,`passports_1445_March_2024`.`ALastname` AS `ALastname`,`passports_1445_March_2024`.`link` AS `link`,`passports_1445_March_2024`.`code` AS `code`,`passports_1445_March_2024`.`machine` AS `machine`,`passports_1445_March_2024`.`timestamp` AS `timestamp` from `passports_1445_March_2024` union select `passports_1445_April_2024`.`passport_id` AS `passport_id`,`passports_1445_April_2024`.`client_id` AS `client_id`,`passports_1445_April_2024`.`pilgrimId` AS `pilgrimId`,`passports_1445_April_2024`.`ppno` AS `ppno`,`passports_1445_April_2024`.`nationality` AS `nationality`,`passports_1445_April_2024`.`mofa` AS `mofa`,`passports_1445_April_2024`.`type` AS `type`,`passports_1445_April_2024`.`Firstname` AS `Firstname`,`passports_1445_April_2024`.`Secondname` AS `Secondname`,`passports_1445_April_2024`.`Thirdname` AS `Thirdname`,`passports_1445_April_2024`.`Lastname` AS `Lastname`,`passports_1445_April_2024`.`AFirstname` AS `AFirstname`,`passports_1445_April_2024`.`ASecondname` AS `ASecondname`,`passports_1445_April_2024`.`AThirdname` AS `AThirdname`,`passports_1445_April_2024`.`ALastname` AS `ALastname`,`passports_1445_April_2024`.`link` AS `link`,`passports_1445_April_2024`.`code` AS `code`,`passports_1445_April_2024`.`machine` AS `machine`,`passports_1445_April_2024`.`timestamp` AS `timestamp` from `passports_1445_April_2024` union select `passports_1445_May_2024`.`passport_id` AS `passport_id`,`passports_1445_May_2024`.`client_id` AS `client_id`,`passports_1445_May_2024`.`pilgrimId` AS `pilgrimId`,`passports_1445_May_2024`.`ppno` AS `ppno`,`passports_1445_May_2024`.`nationality` AS `nationality`,`passports_1445_May_2024`.`mofa` AS `mofa`,`passports_1445_May_2024`.`type` AS `type`,`passports_1445_May_2024`.`Firstname` AS `Firstname`,`passports_1445_May_2024`.`Secondname` AS `Secondname`,`passports_1445_May_2024`.`Thirdname` AS `Thirdname`,`passports_1445_May_2024`.`Lastname` AS `Lastname`,`passports_1445_May_2024`.`AFirstname` AS `AFirstname`,`passports_1445_May_2024`.`ASecondname` AS `ASecondname`,`passports_1445_May_2024`.`AThirdname` AS `AThirdname`,`passports_1445_May_2024`.`ALastname` AS `ALastname`,`passports_1445_May_2024`.`link` AS `link`,`passports_1445_May_2024`.`code` AS `code`,`passports_1445_May_2024`.`machine` AS `machine`,`passports_1445_May_2024`.`timestamp` AS `timestamp` from `passports_1445_May_2024` union select `passports_1445_June_2024`.`passport_id` AS `passport_id`,`passports_1445_June_2024`.`client_id` AS `client_id`,`passports_1445_June_2024`.`pilgrimId` AS `pilgrimId`,`passports_1445_June_2024`.`ppno` AS `ppno`,`passports_1445_June_2024`.`nationality` AS `nationality`,`passports_1445_June_2024`.`mofa` AS `mofa`,`passports_1445_June_2024`.`type` AS `type`,`passports_1445_June_2024`.`Firstname` AS `Firstname`,`passports_1445_June_2024`.`Secondname` AS `Secondname`,`passports_1445_June_2024`.`Thirdname` AS `Thirdname`,`passports_1445_June_2024`.`Lastname` AS `Lastname`,`passports_1445_June_2024`.`AFirstname` AS `AFirstname`,`passports_1445_June_2024`.`ASecondname` AS `ASecondname`,`passports_1445_June_2024`.`AThirdname` AS `AThirdname`,`passports_1445_June_2024`.`ALastname` AS `ALastname`,`passports_1445_June_2024`.`link` AS `link`,`passports_1445_June_2024`.`code` AS `code`,`passports_1445_June_2024`.`machine` AS `machine`,`passports_1445_June_2024`.`timestamp` AS `timestamp` from `passports_1445_June_2024`;

-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `passports_1446_2024`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `passports_1446_2024` AS select `passports_1446_June_2024`.`passport_id` AS `passport_id`,`passports_1446_June_2024`.`client_id` AS `client_id`,`passports_1446_June_2024`.`pilgrimId` AS `pilgrimId`,`passports_1446_June_2024`.`ppno` AS `ppno`,`passports_1446_June_2024`.`nationality` AS `nationality`,`passports_1446_June_2024`.`mofa` AS `mofa`,`passports_1446_June_2024`.`type` AS `type`,`passports_1446_June_2024`.`Firstname` AS `Firstname`,`passports_1446_June_2024`.`Secondname` AS `Secondname`,`passports_1446_June_2024`.`Thirdname` AS `Thirdname`,`passports_1446_June_2024`.`Lastname` AS `Lastname`,`passports_1446_June_2024`.`AFirstname` AS `AFirstname`,`passports_1446_June_2024`.`ASecondname` AS `ASecondname`,`passports_1446_June_2024`.`AThirdname` AS `AThirdname`,`passports_1446_June_2024`.`ALastname` AS `ALastname`,`passports_1446_June_2024`.`link` AS `link`,`passports_1446_June_2024`.`code` AS `code`,`passports_1446_June_2024`.`machine` AS `machine`,`passports_1446_June_2024`.`timestamp` AS `timestamp` from `passports_1446_June_2024` union select `passports_1446_July_2024`.`passport_id` AS `passport_id`,`passports_1446_July_2024`.`client_id` AS `client_id`,`passports_1446_July_2024`.`pilgrimId` AS `pilgrimId`,`passports_1446_July_2024`.`ppno` AS `ppno`,`passports_1446_July_2024`.`nationality` AS `nationality`,`passports_1446_July_2024`.`mofa` AS `mofa`,`passports_1446_July_2024`.`type` AS `type`,`passports_1446_July_2024`.`Firstname` AS `Firstname`,`passports_1446_July_2024`.`Secondname` AS `Secondname`,`passports_1446_July_2024`.`Thirdname` AS `Thirdname`,`passports_1446_July_2024`.`Lastname` AS `Lastname`,`passports_1446_July_2024`.`AFirstname` AS `AFirstname`,`passports_1446_July_2024`.`ASecondname` AS `ASecondname`,`passports_1446_July_2024`.`AThirdname` AS `AThirdname`,`passports_1446_July_2024`.`ALastname` AS `ALastname`,`passports_1446_July_2024`.`link` AS `link`,`passports_1446_July_2024`.`code` AS `code`,`passports_1446_July_2024`.`machine` AS `machine`,`passports_1446_July_2024`.`timestamp` AS `timestamp` from `passports_1446_July_2024` union select `passports_1446_August_2024`.`passport_id` AS `passport_id`,`passports_1446_August_2024`.`client_id` AS `client_id`,`passports_1446_August_2024`.`pilgrimId` AS `pilgrimId`,`passports_1446_August_2024`.`ppno` AS `ppno`,`passports_1446_August_2024`.`nationality` AS `nationality`,`passports_1446_August_2024`.`mofa` AS `mofa`,`passports_1446_August_2024`.`type` AS `type`,`passports_1446_August_2024`.`Firstname` AS `Firstname`,`passports_1446_August_2024`.`Secondname` AS `Secondname`,`passports_1446_August_2024`.`Thirdname` AS `Thirdname`,`passports_1446_August_2024`.`Lastname` AS `Lastname`,`passports_1446_August_2024`.`AFirstname` AS `AFirstname`,`passports_1446_August_2024`.`ASecondname` AS `ASecondname`,`passports_1446_August_2024`.`AThirdname` AS `AThirdname`,`passports_1446_August_2024`.`ALastname` AS `ALastname`,`passports_1446_August_2024`.`link` AS `link`,`passports_1446_August_2024`.`code` AS `code`,`passports_1446_August_2024`.`machine` AS `machine`,`passports_1446_August_2024`.`timestamp` AS `timestamp` from `passports_1446_August_2024` union select `passports_1446_September_2024`.`passport_id` AS `passport_id`,`passports_1446_September_2024`.`client_id` AS `client_id`,`passports_1446_September_2024`.`pilgrimId` AS `pilgrimId`,`passports_1446_September_2024`.`ppno` AS `ppno`,`passports_1446_September_2024`.`nationality` AS `nationality`,`passports_1446_September_2024`.`mofa` AS `mofa`,`passports_1446_September_2024`.`type` AS `type`,`passports_1446_September_2024`.`Firstname` AS `Firstname`,`passports_1446_September_2024`.`Secondname` AS `Secondname`,`passports_1446_September_2024`.`Thirdname` AS `Thirdname`,`passports_1446_September_2024`.`Lastname` AS `Lastname`,`passports_1446_September_2024`.`AFirstname` AS `AFirstname`,`passports_1446_September_2024`.`ASecondname` AS `ASecondname`,`passports_1446_September_2024`.`AThirdname` AS `AThirdname`,`passports_1446_September_2024`.`ALastname` AS `ALastname`,`passports_1446_September_2024`.`link` AS `link`,`passports_1446_September_2024`.`code` AS `code`,`passports_1446_September_2024`.`machine` AS `machine`,`passports_1446_September_2024`.`timestamp` AS `timestamp` from `passports_1446_September_2024` union select `passports_1446_October_2024`.`passport_id` AS `passport_id`,`passports_1446_October_2024`.`client_id` AS `client_id`,`passports_1446_October_2024`.`pilgrimId` AS `pilgrimId`,`passports_1446_October_2024`.`ppno` AS `ppno`,`passports_1446_October_2024`.`nationality` AS `nationality`,`passports_1446_October_2024`.`mofa` AS `mofa`,`passports_1446_October_2024`.`type` AS `type`,`passports_1446_October_2024`.`Firstname` AS `Firstname`,`passports_1446_October_2024`.`Secondname` AS `Secondname`,`passports_1446_October_2024`.`Thirdname` AS `Thirdname`,`passports_1446_October_2024`.`Lastname` AS `Lastname`,`passports_1446_October_2024`.`AFirstname` AS `AFirstname`,`passports_1446_October_2024`.`ASecondname` AS `ASecondname`,`passports_1446_October_2024`.`AThirdname` AS `AThirdname`,`passports_1446_October_2024`.`ALastname` AS `ALastname`,`passports_1446_October_2024`.`link` AS `link`,`passports_1446_October_2024`.`code` AS `code`,`passports_1446_October_2024`.`machine` AS `machine`,`passports_1446_October_2024`.`timestamp` AS `timestamp` from `passports_1446_October_2024` union select `passports_1446_November_2024`.`passport_id` AS `passport_id`,`passports_1446_November_2024`.`client_id` AS `client_id`,`passports_1446_November_2024`.`pilgrimId` AS `pilgrimId`,`passports_1446_November_2024`.`ppno` AS `ppno`,`passports_1446_November_2024`.`nationality` AS `nationality`,`passports_1446_November_2024`.`mofa` AS `mofa`,`passports_1446_November_2024`.`type` AS `type`,`passports_1446_November_2024`.`Firstname` AS `Firstname`,`passports_1446_November_2024`.`Secondname` AS `Secondname`,`passports_1446_November_2024`.`Thirdname` AS `Thirdname`,`passports_1446_November_2024`.`Lastname` AS `Lastname`,`passports_1446_November_2024`.`AFirstname` AS `AFirstname`,`passports_1446_November_2024`.`ASecondname` AS `ASecondname`,`passports_1446_November_2024`.`AThirdname` AS `AThirdname`,`passports_1446_November_2024`.`ALastname` AS `ALastname`,`passports_1446_November_2024`.`link` AS `link`,`passports_1446_November_2024`.`code` AS `code`,`passports_1446_November_2024`.`machine` AS `machine`,`passports_1446_November_2024`.`timestamp` AS `timestamp` from `passports_1446_November_2024` union select `passports_1446_December_2024`.`passport_id` AS `passport_id`,`passports_1446_December_2024`.`client_id` AS `client_id`,`passports_1446_December_2024`.`pilgrimId` AS `pilgrimId`,`passports_1446_December_2024`.`ppno` AS `ppno`,`passports_1446_December_2024`.`nationality` AS `nationality`,`passports_1446_December_2024`.`mofa` AS `mofa`,`passports_1446_December_2024`.`type` AS `type`,`passports_1446_December_2024`.`Firstname` AS `Firstname`,`passports_1446_December_2024`.`Secondname` AS `Secondname`,`passports_1446_December_2024`.`Thirdname` AS `Thirdname`,`passports_1446_December_2024`.`Lastname` AS `Lastname`,`passports_1446_December_2024`.`AFirstname` AS `AFirstname`,`passports_1446_December_2024`.`ASecondname` AS `ASecondname`,`passports_1446_December_2024`.`AThirdname` AS `AThirdname`,`passports_1446_December_2024`.`ALastname` AS `ALastname`,`passports_1446_December_2024`.`link` AS `link`,`passports_1446_December_2024`.`code` AS `code`,`passports_1446_December_2024`.`machine` AS `machine`,`passports_1446_December_2024`.`timestamp` AS `timestamp` from `passports_1446_December_2024` union select `passports_1446_January_2025`.`passport_id` AS `passport_id`,`passports_1446_January_2025`.`client_id` AS `client_id`,`passports_1446_January_2025`.`pilgrimId` AS `pilgrimId`,`passports_1446_January_2025`.`ppno` AS `ppno`,`passports_1446_January_2025`.`nationality` AS `nationality`,`passports_1446_January_2025`.`mofa` AS `mofa`,`passports_1446_January_2025`.`type` AS `type`,`passports_1446_January_2025`.`Firstname` AS `Firstname`,`passports_1446_January_2025`.`Secondname` AS `Secondname`,`passports_1446_January_2025`.`Thirdname` AS `Thirdname`,`passports_1446_January_2025`.`Lastname` AS `Lastname`,`passports_1446_January_2025`.`AFirstname` AS `AFirstname`,`passports_1446_January_2025`.`ASecondname` AS `ASecondname`,`passports_1446_January_2025`.`AThirdname` AS `AThirdname`,`passports_1446_January_2025`.`ALastname` AS `ALastname`,`passports_1446_January_2025`.`link` AS `link`,`passports_1446_January_2025`.`code` AS `code`,`passports_1446_January_2025`.`machine` AS `machine`,`passports_1446_January_2025`.`timestamp` AS `timestamp` from `passports_1446_January_2025` union select `passports_1446_February_2025`.`passport_id` AS `passport_id`,`passports_1446_February_2025`.`client_id` AS `client_id`,`passports_1446_February_2025`.`pilgrimId` AS `pilgrimId`,`passports_1446_February_2025`.`ppno` AS `ppno`,`passports_1446_February_2025`.`nationality` AS `nationality`,`passports_1446_February_2025`.`mofa` AS `mofa`,`passports_1446_February_2025`.`type` AS `type`,`passports_1446_February_2025`.`Firstname` AS `Firstname`,`passports_1446_February_2025`.`Secondname` AS `Secondname`,`passports_1446_February_2025`.`Thirdname` AS `Thirdname`,`passports_1446_February_2025`.`Lastname` AS `Lastname`,`passports_1446_February_2025`.`AFirstname` AS `AFirstname`,`passports_1446_February_2025`.`ASecondname` AS `ASecondname`,`passports_1446_February_2025`.`AThirdname` AS `AThirdname`,`passports_1446_February_2025`.`ALastname` AS `ALastname`,`passports_1446_February_2025`.`link` AS `link`,`passports_1446_February_2025`.`code` AS `code`,`passports_1446_February_2025`.`machine` AS `machine`,`passports_1446_February_2025`.`timestamp` AS `timestamp` from `passports_1446_February_2025` union select `passports_1446_March_2025`.`passport_id` AS `passport_id`,`passports_1446_March_2025`.`client_id` AS `client_id`,`passports_1446_March_2025`.`pilgrimId` AS `pilgrimId`,`passports_1446_March_2025`.`ppno` AS `ppno`,`passports_1446_March_2025`.`nationality` AS `nationality`,`passports_1446_March_2025`.`mofa` AS `mofa`,`passports_1446_March_2025`.`type` AS `type`,`passports_1446_March_2025`.`Firstname` AS `Firstname`,`passports_1446_March_2025`.`Secondname` AS `Secondname`,`passports_1446_March_2025`.`Thirdname` AS `Thirdname`,`passports_1446_March_2025`.`Lastname` AS `Lastname`,`passports_1446_March_2025`.`AFirstname` AS `AFirstname`,`passports_1446_March_2025`.`ASecondname` AS `ASecondname`,`passports_1446_March_2025`.`AThirdname` AS `AThirdname`,`passports_1446_March_2025`.`ALastname` AS `ALastname`,`passports_1446_March_2025`.`link` AS `link`,`passports_1446_March_2025`.`code` AS `code`,`passports_1446_March_2025`.`machine` AS `machine`,`passports_1446_March_2025`.`timestamp` AS `timestamp` from `passports_1446_March_2025` union select `passports_1446_April_2025`.`passport_id` AS `passport_id`,`passports_1446_April_2025`.`client_id` AS `client_id`,`passports_1446_April_2025`.`pilgrimId` AS `pilgrimId`,`passports_1446_April_2025`.`ppno` AS `ppno`,`passports_1446_April_2025`.`nationality` AS `nationality`,`passports_1446_April_2025`.`mofa` AS `mofa`,`passports_1446_April_2025`.`type` AS `type`,`passports_1446_April_2025`.`Firstname` AS `Firstname`,`passports_1446_April_2025`.`Secondname` AS `Secondname`,`passports_1446_April_2025`.`Thirdname` AS `Thirdname`,`passports_1446_April_2025`.`Lastname` AS `Lastname`,`passports_1446_April_2025`.`AFirstname` AS `AFirstname`,`passports_1446_April_2025`.`ASecondname` AS `ASecondname`,`passports_1446_April_2025`.`AThirdname` AS `AThirdname`,`passports_1446_April_2025`.`ALastname` AS `ALastname`,`passports_1446_April_2025`.`link` AS `link`,`passports_1446_April_2025`.`code` AS `code`,`passports_1446_April_2025`.`machine` AS `machine`,`passports_1446_April_2025`.`timestamp` AS `timestamp` from `passports_1446_April_2025` union select `passports_1446_May_2025`.`passport_id` AS `passport_id`,`passports_1446_May_2025`.`client_id` AS `client_id`,`passports_1446_May_2025`.`pilgrimId` AS `pilgrimId`,`passports_1446_May_2025`.`ppno` AS `ppno`,`passports_1446_May_2025`.`nationality` AS `nationality`,`passports_1446_May_2025`.`mofa` AS `mofa`,`passports_1446_May_2025`.`type` AS `type`,`passports_1446_May_2025`.`Firstname` AS `Firstname`,`passports_1446_May_2025`.`Secondname` AS `Secondname`,`passports_1446_May_2025`.`Thirdname` AS `Thirdname`,`passports_1446_May_2025`.`Lastname` AS `Lastname`,`passports_1446_May_2025`.`AFirstname` AS `AFirstname`,`passports_1446_May_2025`.`ASecondname` AS `ASecondname`,`passports_1446_May_2025`.`AThirdname` AS `AThirdname`,`passports_1446_May_2025`.`ALastname` AS `ALastname`,`passports_1446_May_2025`.`link` AS `link`,`passports_1446_May_2025`.`code` AS `code`,`passports_1446_May_2025`.`machine` AS `machine`,`passports_1446_May_2025`.`timestamp` AS `timestamp` from `passports_1446_May_2025` union select `passports_1446_June_2025`.`passport_id` AS `passport_id`,`passports_1446_June_2025`.`client_id` AS `client_id`,`passports_1446_June_2025`.`pilgrimId` AS `pilgrimId`,`passports_1446_June_2025`.`ppno` AS `ppno`,`passports_1446_June_2025`.`nationality` AS `nationality`,`passports_1446_June_2025`.`mofa` AS `mofa`,`passports_1446_June_2025`.`type` AS `type`,`passports_1446_June_2025`.`Firstname` AS `Firstname`,`passports_1446_June_2025`.`Secondname` AS `Secondname`,`passports_1446_June_2025`.`Thirdname` AS `Thirdname`,`passports_1446_June_2025`.`Lastname` AS `Lastname`,`passports_1446_June_2025`.`AFirstname` AS `AFirstname`,`passports_1446_June_2025`.`ASecondname` AS `ASecondname`,`passports_1446_June_2025`.`AThirdname` AS `AThirdname`,`passports_1446_June_2025`.`ALastname` AS `ALastname`,`passports_1446_June_2025`.`link` AS `link`,`passports_1446_June_2025`.`code` AS `code`,`passports_1446_June_2025`.`machine` AS `machine`,`passports_1446_June_2025`.`timestamp` AS `timestamp` from `passports_1446_June_2025` union select `passports_1446_July_2025`.`passport_id` AS `passport_id`,`passports_1446_July_2025`.`client_id` AS `client_id`,`passports_1446_July_2025`.`pilgrimId` AS `pilgrimId`,`passports_1446_July_2025`.`ppno` AS `ppno`,`passports_1446_July_2025`.`nationality` AS `nationality`,`passports_1446_July_2025`.`mofa` AS `mofa`,`passports_1446_July_2025`.`type` AS `type`,`passports_1446_July_2025`.`Firstname` AS `Firstname`,`passports_1446_July_2025`.`Secondname` AS `Secondname`,`passports_1446_July_2025`.`Thirdname` AS `Thirdname`,`passports_1446_July_2025`.`Lastname` AS `Lastname`,`passports_1446_July_2025`.`AFirstname` AS `AFirstname`,`passports_1446_July_2025`.`ASecondname` AS `ASecondname`,`passports_1446_July_2025`.`AThirdname` AS `AThirdname`,`passports_1446_July_2025`.`ALastname` AS `ALastname`,`passports_1446_July_2025`.`link` AS `link`,`passports_1446_July_2025`.`code` AS `code`,`passports_1446_July_2025`.`machine` AS `machine`,`passports_1446_July_2025`.`timestamp` AS `timestamp` from `passports_1446_July_2025` union select `passports_1446_August_2025`.`passport_id` AS `passport_id`,`passports_1446_August_2025`.`client_id` AS `client_id`,`passports_1446_August_2025`.`pilgrimId` AS `pilgrimId`,`passports_1446_August_2025`.`ppno` AS `ppno`,`passports_1446_August_2025`.`nationality` AS `nationality`,`passports_1446_August_2025`.`mofa` AS `mofa`,`passports_1446_August_2025`.`type` AS `type`,`passports_1446_August_2025`.`Firstname` AS `Firstname`,`passports_1446_August_2025`.`Secondname` AS `Secondname`,`passports_1446_August_2025`.`Thirdname` AS `Thirdname`,`passports_1446_August_2025`.`Lastname` AS `Lastname`,`passports_1446_August_2025`.`AFirstname` AS `AFirstname`,`passports_1446_August_2025`.`ASecondname` AS `ASecondname`,`passports_1446_August_2025`.`AThirdname` AS `AThirdname`,`passports_1446_August_2025`.`ALastname` AS `ALastname`,`passports_1446_August_2025`.`link` AS `link`,`passports_1446_August_2025`.`code` AS `code`,`passports_1446_August_2025`.`machine` AS `machine`,`passports_1446_August_2025`.`timestamp` AS `timestamp` from `passports_1446_August_2025`;

-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `passports_counter`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `passports_counter` AS select `passports_1445`.`client_id` AS `client_id`,`tbl_clients`.`CompanyName` AS `companyname`,count(0) AS `count(*)` from (`passports_1445` left join `tbl_clients` on(`tbl_clients`.`Id` = `passports_1445`.`client_id`)) group by `passports_1445`.`client_id`;

-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `passports_view`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `passports_view` AS select `passports_1446_2024`.`client_id` AS `client_id`,`passports_1446_2024`.`type` AS `type`,count(0) AS `Counter` from `passports_1446_2024` group by `passports_1446_2024`.`client_id`,`passports_1446_2024`.`type`,`passports_1446_2024`.`ppno`,`passports_1446_2024`.`nationality`;

-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `re`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `re` AS select `crm_ea_machines`.`crm_ea_machine_id` AS `crm_ea_machine_id`,`crm_ea_machines`.`safa_ea_id` AS `safa_ea_id`,`crm_ea_machines`.`last_access` AS `last_access`,`crm_ea_machines`.`code` AS `code`,`crm_ea_machines`.`ip` AS `ip`,`crm_ea_machines`.`hash` AS `hash`,`crm_ea_machines`.`name` AS `name`,`crm_ea_machines`.`safa_client_id` AS `safa_client_id` from `crm_ea_machines`;

-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `season_1439`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `season_1439` AS select `visas_1439`.`client_id` AS `client_id`,`tbl_clients`.`CompanyName` AS `companyname`,count(0) AS `visa_count`,`tbl_clients_applications`.`Time_stamp` AS `Time_stamp`,`tbl_clients_applications`.`Version` AS `Version` from ((`visas_1439` left join `tbl_clients` on(`tbl_clients`.`Id` = `visas_1439`.`client_id`)) left join `tbl_clients_applications` on(`tbl_clients_applications`.`Client_id` = `visas_1439`.`client_id`)) where `tbl_clients_applications`.`App_Id` = 6 group by `visas_1439`.`client_id`;

-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `summary_1441`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `summary_1441` AS select `visas_1443`.`client_id` AS `client_id`,`tbl_clients`.`CompanyName` AS `Company`,`tbl_countries`.`CNTRY_NAME_LA` AS `Country`,count(0) AS `Counter` from ((`visas_1443` left join `tbl_clients` on(`tbl_clients`.`Id` = `visas_1443`.`client_id`)) left join `tbl_countries` on(`tbl_clients`.`Country` = `tbl_countries`.`CNTRY_ID`)) where `visas_1443`.`type` = 1 group by `visas_1443`.`client_id` order by count(0) desc;

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
