<?php
//============ FUNCTION TO CHECK IF THE USER IS LOGGGED IN OR NOW ===============
//logged_in();
//===============================================================================
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit();
}

//============ FUNCTION TO OPEN THE CURRENT PAGE  ===============================
//pages();
$ID = isset($_GET['id']) ? $_GET['id'] : null;
$Form_Process = "/form_process.php?page=";
//===============================================================================


// Get the requested page from URL parameter
$page = isset($_GET['page']) ? $_GET['page'] : 'dashboard';

// Special handling for search parameter - redirect to search_clients if search is present
if (isset($_GET['search']) && !isset($_GET['page'])) {
    $page = 'search_clients';
}

// Define the path to the pages directory
$pages_path = "pages/";

// Map page parameters to actual file names
$page_mapping = [
    'dashboard' => 'dashboard.php',
    'accounts' => 'accounts.php',
    'add_client' => 'add_client.php',
    'edit_clients' => 'edit_clients.php',
    'edit_client' => 'edit_client.php',
    'search_clients' => 'search_clients.php',
    'add_credit' => 'add_credit.php',
    'low_credit' => 'low_credit.php',
    'invoices' => 'invoices.php',
    'invoice_create' => 'invoice_create.php',
    'invoice_view' => 'invoice_view.php',
    'invoice_edit' => 'invoice_edit.php',
    'payments' => 'payments.php',
    'payment_create' => 'payment_create.php',
    'payment_view' => 'payment_view.php',
    'payment_allocate' => 'payment_allocate.php',
    'account_managers' => 'account_managers.php',
    'currency_rates' => 'currency_rates.php'
];

// Debug information
/*echo '<div class="alert alert-info mb-3">
        <strong>Debug Info:</strong><br>
        Requested Page: ' . htmlspecialchars($page) . '<br>
        Mapped File: ' . (isset($page_mapping[$page]) ? htmlspecialchars($page_mapping[$page]) : 'Not Mapped') . '<br>
        Full Path: ' . htmlspecialchars($pages_path . ($page_mapping[$page] ?? 'undefined')) . '<br>
        File Exists: ' . (isset($page_mapping[$page]) && file_exists($pages_path . $page_mapping[$page]) ? 'Yes' : 'No') . '
      </div>';*/

// Check if the requested page exists in our mapping
if (isset($page_mapping[$page])) {
    $file_path = $pages_path . $page_mapping[$page];
    
    // Check if the file exists
    if (file_exists($file_path)) {
        include($file_path);
    } else {
        echo '<div class="alert alert-danger">
                <h4>Error 404</h4>
                <p>The requested page "' . htmlspecialchars($file_path) . '" was not found.</p>
                <p>Please make sure all required files are in the correct location.</p>
              </div>';
    }
} else {
    // If page is not in mapping, show dashboard
    include($pages_path . 'dashboard.php');
}
?>
