<!-- ========== FORM LAYOUT ===================================== -->
<div class="container-fluid px-4">
    <h1 class="mt-4">Add New Client</h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="index.php">Dashboard</a></li>
        <li class="breadcrumb-item active">Add Client</li>
    </ol>

    <div class="card mb-4">
        <div class="card-header">
            <i class="fas fa-user-plus me-1"></i>
            Client Information
        </div>
        <div class="card-body">
            <?php Message("added_successfully","success","success_icon.png","New Client Successfully Added"); ?>
            <?php $Page = "add_Client"; ?>

            <form action="<?php echo SITE_URL . '/form_process.php?page=add_client'; ?>" method="post">
                <div class="row mb-3">
                    <div class="col-md-6"> 
                        <div class="form-floating mb-3">
                            <input type="text" name="Company_name" class="form-control" id="companyName" placeholder="Company Name">
                            <label for="companyName">Company Name</label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-floating mb-3">
                            <input type="text" name="Person_Incharge" class="form-control" id="personIncharge" placeholder="Person Incharge">
                            <label for="personIncharge">Person In Charge</label>
                        </div>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="form-floating mb-3">
                            <select name="Country" id="Country" class="form-select">
                                <option value=''>--- Select Country ---</option>
                                <?php Get_Countries(); ?>
                            </select>
                            <label for="Country">Country</label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-floating mb-3">
                            <input type="text" name="City" class="form-control" id="city" placeholder="City">
                            <label for="city">City</label>
                        </div>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="form-floating mb-3">
                            <input type="tel" name="Telephone" class="form-control" id="telephone" placeholder="Telephone">
                            <label for="telephone">Telephone</label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-floating mb-3">
                            <input type="email" name="Email" required class="form-control" id="email" placeholder="Email">
                            <label for="email">Email</label>
                        </div>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="form-floating mb-3">
                            <input type="email" name="license_email" class="form-control" id="license_email" placeholder="License Email">
                            <label for="license_email">License Email</label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-floating mb-3">
                            <select name="account_manager_id" class="form-select" id="account_manager_id">
                                <option value="">--- Select Account Manager ---</option>
                                <?php
                                try {
                                    $dbo = new DataBaseObjects();
                                    $managers = $dbo->selectAll('tbl_account_managers', 'id, name');
                                    foreach ($managers as $m) {
                                        echo "<option value='".htmlspecialchars($m['id'])."'>".htmlspecialchars($m['name'])."</option>";
                                    }
                                } catch (Exception $e) {
                                    
                                }
                                ?>
                            </select>
                            <label for="account_manager_id">Account Manager</label>
                        </div>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="form-floating mb-3">
                            <input type="text" name="MSN" class="form-control" id="msn" placeholder="MSN">
                            <label for="msn">MSN</label>
                        </div>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="form-floating mb-3">
                            <input type="text" name="Start_Balance" class="form-control" id="startBalance" placeholder="Start Balance">
                            <label for="startBalance">Start Balance</label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-floating mb-3">
                            <input type="date" name="Purchase_Date" class="form-control" id="purchaseDate" value="<?php echo date('Y-m-d'); ?>">
                            <label for="purchaseDate">Purchase Date</label>
                        </div>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="form-floating mb-3">
                            <input type="date" name="Renew_Date" class="form-control" id="renewDate" value="<?php echo date('Y-m-d'); ?>">
                            <label for="renewDate">Expiry Date</label>
                        </div>
                    </div>
                </div>

                <div class="form-floating mb-3">
                    <textarea name="Message" class="form-control" id="message" style="height: 100px" placeholder="Message"></textarea>
                    <label for="message">Message</label>
                </div>

                <div class="mt-4 mb-0">
                    <div class="d-grid">
                        <button type="submit" name="submit" class="btn btn-primary btn-block">Add Client</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
