<?php
// Script to update the database schema by adding new columns
// Include configuration file
include_once("includes/config.php");

try {
    // SQL query to add new columns
    $sql = "ALTER TABLE `tbl_clients` 
            ADD COLUMN IF NOT EXISTS `enjaz_feeding_center` TINYINT(4) NOT NULL DEFAULT 0 AFTER `license_enabled`,
            ADD COLUMN IF NOT EXISTS `umrah_feeding_center` TINYINT(4) NOT NULL DEFAULT 0 AFTER `enjaz_feeding_center`,
            ADD COLUMN IF NOT EXISTS `enjaz_payment` TINYINT(4) NOT NULL DEFAULT 0 AFTER `umrah_feeding_center`;";

    // SQL query to add new columns
    $sql .= "CREATE TABLE IF NOT EXISTS `license_settings` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `license_code` varchar(50) NOT NULL,
        `machine_code` varchar(100) NOT NULL,
        `settings_json` text NOT NULL,
        `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
        `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
        PRIMARY KEY (`id`),
        UNIQUE KEY `license_machine` (`license_code`, `machine_code`),
        CONSTRAINT `FK_license_settings_license` FOREIGN KEY (`license_code`) REFERENCES `license` (`license_code`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;";
    
    // Execute the query
    $result = $db1->exec($sql);
    
    echo "<div style='background-color: #dff0d8; color: #3c763d; padding: 15px; margin: 20px; border-radius: 5px;'>";
    echo "<h3>Database Update Successful</h3>";
    echo "<p>The database has been updated with new columns for 'Enjaz Feeding Center', 'Umrah Feeding Center', and 'Enjaz Payment'.</p>";
    echo "<p>You can now return to the <a href='index.php'>main page</a>.</p>";
    echo "</div>";
} catch (PDOException $e) {
    echo "<div style='background-color: #f2dede; color: #a94442; padding: 15px; margin: 20px; border-radius: 5px;'>";
    echo "<h3>Error</h3>";
    echo "<p>Failed to update database: " . $e->getMessage() . "</p>";
    echo "</div>";
}
?> 