<?php

require_once("../includes/config.php");
$CNTRY_ID = isset($_GET["CNTRY_ID"]) ? $_GET["CNTRY_ID"] : "";

//========================================================================================================================
$table_suffix = 1446; // Replace this number as needed
$passports = "passports_".$table_suffix."_2024";
$sql_base = "SELECT *,
    (SELECT license_code FROM license WHERE client_id = tbl_clients.Id LIMIT 1) AS LicenseCode,
    (SELECT COUNT(*) FROM visas_$table_suffix WHERE client_id= tbl_clients.Id AND `type`<>3) AS v$table_suffix,
    (SELECT COUNT(*) FROM $passports WHERE client_id= tbl_clients.Id) AS p$table_suffix,
    (SELECT COUNT(*) FROM visas_$table_suffix WHERE client_id= tbl_clients.Id AND `type`=3) AS e$table_suffix,
    (SELECT stop_at FROM tbl_clients_applications WHERE app_id=4 AND client_id=tbl_clients.id LIMIT 1) AS credit,
    (SELECT time_stamp FROM tbl_clients_applications WHERE app_id=4 AND client_id=tbl_clients.id LIMIT 1) AS last_access,
    (SELECT stop_at FROM tbl_clients_applications WHERE app_id=4 AND client_id=tbl_clients.id LIMIT 1) / NULLIF((SELECT COUNT(*) FROM visas_$table_suffix WHERE client_id=tbl_clients.Id), 0) AS credit_ratio
    FROM tbl_clients";

if ($CNTRY_ID == "all") {
    $sql = "$sql_base 
            ORDER BY 
            CASE WHEN credit_ratio IS NULL THEN 1 ELSE 0 END,  -- Push rows with 0 package to the bottom
            credit_ratio ASC,  -- Sort by credit/package ratio for non-zero packages
            (SELECT time_stamp FROM tbl_clients_applications WHERE app_id=4 AND client_id=tbl_clients.id LIMIT 1) DESC";
} else {
    $sql = "$sql_base 
            WHERE Country = :country 
            ORDER BY 
            CASE WHEN credit_ratio IS NULL THEN 1 ELSE 0 END, 
            credit_ratio ASC, 
            (SELECT time_stamp FROM tbl_clients_applications WHERE app_id=4 AND client_id=tbl_clients.id LIMIT 1) DESC";
}

$stmt = $db1->prepare($sql);

if ($CNTRY_ID != "all") {
    $stmt->bindParam(':country', $CNTRY_ID);
}

$stmt->execute();
$result = $stmt->fetchAll(PDO::FETCH_ASSOC);

$count = count($result);

//************************* HEADER ***************************************************************************** 
echo "<div class='container mt-4'>";
echo "<h3>Results <strong>($count)</strong></h3>";

echo "<div class='table-responsive'>";
echo "<table class='table table-striped table-bordered'>";
echo "<thead class='table-light'>
        <tr>
            <th>Company Name</th>
            <th>License Code</th>
            <th>Package / Credit</th>
            <th>Passports / Visas / Enjaz</th>
            <th>Last Access</th>
            <th>Edit</th>
        </tr>
      </thead>
      <tbody>";

//***************************************************************************************************************
foreach ($result as $row) {
    $credit = $row['credit'] - $row["p$table_suffix"];
    $short_license_code = substr($row['LicenseCode'], 0, 6) . '...';

    // Calculate if the credit is less than 20% of the package
    $package = $row['credit']; // Assuming the package value is stored in 'credit'
    $credit_percentage = ($package > 0) ? ($credit / $package) * 100 : 0;

    // Apply the flashing class if the credit is less than 20% of the package
    $flash_class = ($credit_percentage < 20) ? 'flashing-red' : '';

    echo "<tr>";
    echo "<td align='center'>" . htmlspecialchars($row['CompanyName']) . "</td>";
    
    // License Code with Hover to Copy
    echo "<td align='center'>
            <span class='license-code' title='Click to copy' onclick='copyToClipboard(\"" . htmlspecialchars($row['LicenseCode']) . "\")' style='cursor: pointer;'>
                " . htmlspecialchars($short_license_code) . "
            </span>
          </td>";

    // Package / Credit in one cell with conditional flashing
    echo "<td align='center' class='$flash_class'>
            " . htmlspecialchars($row['credit']) . "<br>
            " . htmlspecialchars($credit) . "
          </td>";

    // Passports / Visas / Enjaz in one cell
    echo "<td align='center'>
            " . htmlspecialchars($row["p$table_suffix"]) . "<br>
            " . htmlspecialchars($row["v$table_suffix"]) . "<br>
            " . htmlspecialchars($row["e$table_suffix"]) . "
          </td>";

    // Last Access with Time and Date on separate lines
    $timestamp = strtotime($row['last_access']);
    $time = date('H:i:s', $timestamp);
    $date = date('Y-m-d', $timestamp);

    echo "<td align='center'>
            <span>$time</span><br>
            <span>$date</span>
          </td>";

    // Edit button
    echo "<td align='center'>
            <a href='?page=edit_client&id={$row['Id']}'>
                <img src='../images/edit.gif' width='12' height='18' border='0' alt='Edit' title='Edit' />
            </a>
          </td>";
    echo "</tr>";
}
    /*
foreach ($result as $row) {
    $row_color = ($row_count % 2) ? $color1 : $color2;
    $credit = $row['credit'] - $row["p$table_suffix"];
    $package = $row["credit"];
    
    // Calculate the percentage
    $credit_percentage = ($package > 0) ? ($credit / $package) * 100 : 0;
    
    // Determine class for flashing effect
    $flash_class = '';
    if ($package > 0 && $credit_percentage < 20) {
        $flash_class = 'flashing-red';
    }

    echo "<tr align='center' bgcolor=$row_color>";
    echo "<td align='center' bgcolor=$row_color>" . $row['CompanyName'] . "</td>";
    // License Code with Hover to Copy
    echo "<td align='center'>
            <span class='license-code' title='Click to copy' onclick='copyToClipboard(\"" . htmlspecialchars($row['LicenseCode']) . "\")' style='cursor: pointer;'>
                " . htmlspecialchars($short_license_code) . "
            </span>
          </td>";

    //echo "<td align='left' bgcolor=$row_color class='license-code'>" . substr($row['LicenseCode'], 0, 8) . "... <span class='tooltiptext'>Click to copy</span></td>";
    echo "<td align='center' class='$flash_class' bgcolor=$row_color>" . $package . " / " . $credit . "</td>";
    echo "<td align='center' bgcolor=$row_color>" . $row["p$table_suffix"] . "</td>";
    echo "<td align='center' bgcolor=$row_color>" . $row["v$table_suffix"] . "</td>";
    echo "<td align='center' bgcolor=$row_color>" . $row["e$table_suffix"] . "</td>";
    echo "<td align='center' bgcolor=$row_color>" . date('H:i', strtotime($row['last_access'])) . "<br>" . date('Y-m-d', strtotime($row['last_access'])) . "</td>";
    echo "<td align='center' bgcolor=$row_color>
            <a href='?page=edit_client&id={$row['Id']}'>
                <img src=../images/edit.gif width=12 height=18 border=0 alt=Edit title='Edit' />
            </a>
          </td>";
    echo "</tr>";
    $row_count++;
}*/

echo "</tbody></table></div>"; // Closing table-responsive div
echo "</div>";
?>
